/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIAutoPruneForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIAutoPruneForm.gtmpl", events={@EventConfig(listeners={PruneSettingActionListener.class}), @EventConfig(listeners={RunPruneActionListener.class}), @EventConfig(listeners={ActivatePruneActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAutoPruneForm
extends BaseForumForm
implements UIPopupComponent {
    private List<PruneSetting> listPruneSetting = new ArrayList();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private List<PruneSetting> getPruneSettings() throws Exception {
        this.listPruneSetting = new ArrayList();
        try {
            for (PruneSetting pruneSetting : this.getForumService().getAllPruneSetting()) {
                this.listPruneSetting.add(pruneSetting);
                UIFormCheckBoxInput isActiveBBcode = this.getUIFormCheckBoxInput(pruneSetting.getId());
                if (isActiveBBcode == null) {
                    isActiveBBcode = new UIFormCheckBoxInput(pruneSetting.getId(), pruneSetting.getId(), (Object)false);
                    this.addUIFormInput((UIFormInput)isActiveBBcode);
                }
                isActiveBBcode.setChecked(pruneSetting.isActive());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed to get prune settings", (Throwable)e);
        }
        return this.listPruneSetting;
    }

    private PruneSetting getPruneSetting(String pruneId) throws Exception {
        for (PruneSetting prune : this.listPruneSetting) {
            if (!prune.getId().equals(pruneId)) continue;
            return prune;
        }
        return new PruneSetting();
    }

    static /* synthetic */ PruneSetting access$000(UIAutoPruneForm x0, String x1) throws Exception {
        return x0.getPruneSetting(x1);
    }

    static /* synthetic */ UIComponent access$100(UIAutoPruneForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ UIComponent access$200(UIAutoPruneForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ ForumService access$300(UIAutoPruneForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ UIComponent access$400(UIAutoPruneForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }
}

