/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UINotificationForm;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UINotificationForm.gtmpl", events={@EventConfig(listeners={GetDefaultMailActionListener.class}), @EventConfig(listeners={SelectTabActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UINotificationForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_ENABLEHEADERSUBJECT_CHECKBOX = "enableHeaderSubject";
    public static final String FIELD_NOTIFYEMAIL_MOVE_TAB = "notifyEmailMoveTab";
    public static final String FIELD_NOTIFYEMAIL_ADDNEW_TAB = "notifyEmailAddNewTab";
    public static final String FIELD_HEADERSUBJECT_INPUT = "headerSubject";
    public static final String FIELD_NOTIFYEMAIL_TEXTAREA = "notifyEmail";
    public static final String FIELD_NOTIFYEMAILMOVED_TEXTAREA = "notifyEmailMoved";
    private ForumAdministration administration;
    private int tabId = 0;

    public UINotificationForm() {
        this.setActions(new String[]{"Save", "Close"});
    }

    public void setInitForm() throws Exception {
        this.administration = this.getForumService().getForumAdministration();
        UIFormInputWithActions notifyEmailAddNewTab = new UIFormInputWithActions(FIELD_NOTIFYEMAIL_ADDNEW_TAB);
        UIFormInputWithActions notifyEmailMoveTab = new UIFormInputWithActions(FIELD_NOTIFYEMAIL_MOVE_TAB);
        UIFormCheckBoxInput enableHeaderSubject = this.initEnableHeaderField();
        UIFormStringInput headerSubject = this.initEnableHeaderSubjectField();
        UIFormWYSIWYGInput notifyEmail = this.initNotifyEmailField();
        UIFormWYSIWYGInput notifyEmailMoved = this.initNotifyMoveField();
        notifyEmailAddNewTab.addUIFormInput((UIFormInput)enableHeaderSubject);
        notifyEmailAddNewTab.addUIFormInput((UIFormInput)headerSubject);
        notifyEmailAddNewTab.addUIFormInput((UIFormInput)notifyEmail);
        notifyEmailMoveTab.addUIFormInput((UIFormInput)notifyEmailMoved);
        this.initEmailField(notifyEmailAddNewTab, FIELD_NOTIFYEMAIL_TEXTAREA);
        this.initEmailField(notifyEmailMoveTab, FIELD_NOTIFYEMAILMOVED_TEXTAREA);
        this.addUIFormInput((UIFormInputSet)notifyEmailAddNewTab);
        this.addUIFormInput((UIFormInputSet)notifyEmailMoveTab);
    }

    private void initEmailField(UIFormInputWithActions notifyEmailTab, String param) throws Exception {
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
        ad.setActionListener("GetDefaultMail");
        ad.setActionParameter(param);
        ad.setCssIconClass("Refresh");
        ad.setActionName("TitleResetMail");
        actions.add(ad);
        notifyEmailTab.setActionField(param, actions);
    }

    private UIFormWYSIWYGInput initNotifyMoveField() {
        String value = this.administration.getNotifyEmailMoved();
        if (ForumUtils.isEmpty((String)value)) {
            value = this.getLabel("EmailToAuthorMoved");
        }
        UIFormWYSIWYGInput notifyEmailMoved = new UIFormWYSIWYGInput(FIELD_NOTIFYEMAILMOVED_TEXTAREA, FIELD_NOTIFYEMAILMOVED_TEXTAREA, "");
        notifyEmailMoved.setToolBarName("Basic");
        notifyEmailMoved.setValue((Object)value);
        return notifyEmailMoved;
    }

    private UIFormWYSIWYGInput initNotifyEmailField() {
        String value = this.administration.getNotifyEmailContent();
        if (ForumUtils.isEmpty((String)value)) {
            value = this.getLabel("notifyEmailContentDefault");
        }
        UIFormWYSIWYGInput notifyEmail = new UIFormWYSIWYGInput(FIELD_NOTIFYEMAIL_TEXTAREA, FIELD_NOTIFYEMAIL_TEXTAREA, "");
        notifyEmail.setToolBarName("Basic");
        notifyEmail.setValue((Object)value);
        return notifyEmail;
    }

    private UIFormStringInput initEnableHeaderSubjectField() {
        UIFormStringInput headerSubject = new UIFormStringInput(FIELD_HEADERSUBJECT_INPUT, FIELD_HEADERSUBJECT_INPUT, null);
        String headerSubject_ = this.administration.getHeaderSubject();
        if (ForumUtils.isEmpty((String)headerSubject_)) {
            headerSubject_ = this.getLabel("notifyEmailHeaderSubjectDefault");
        }
        headerSubject.setValue((Object)headerSubject_);
        return headerSubject;
    }

    private UIFormCheckBoxInput<Boolean> initEnableHeaderField() {
        UIFormCheckBoxInput enableHeaderSubject = new UIFormCheckBoxInput(FIELD_ENABLEHEADERSUBJECT_CHECKBOX, FIELD_ENABLEHEADERSUBJECT_CHECKBOX, (Object)false);
        enableHeaderSubject.setChecked(this.administration.getEnableHeaderSubject());
        return enableHeaderSubject;
    }

    private boolean tabIsSelected(int tabId) {
        return this.tabId == tabId;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ ForumAdministration access$000(UINotificationForm x0) {
        return x0.administration;
    }

    static /* synthetic */ ForumService access$100(UINotificationForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Log access$200(UINotificationForm x0) {
        return x0.log;
    }

    static /* synthetic */ int access$302(UINotificationForm x0, int x1) {
        x0.tabId = x1;
        return x0.tabId;
    }
}

