/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListPostByUser;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/popup/UIPageListPostByUser.gtmpl", events={@EventConfig(listeners={OpenPostLinkActionListener.class}), @EventConfig(listeners={OpenTopicLinkActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={DeletePostLinkActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisPost")})
public class UIPageListPostByUser
extends UIContainer {
    private ForumService forumService;
    private UserProfile userProfile = null;
    private String userName = null;
    private String strOrderBy = "createdDate descending";
    private boolean hasEnableIPLogging = true;
    private List<Post> posts = new ArrayList();

    public UIPageListPostByUser() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIForumPageIterator.class, null, "PageListPostByUser");
    }

    public boolean getHasEnableIPLogging() {
        return this.hasEnableIPLogging;
    }

    private UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
            this.userProfile = forumPortlet.getUserProfile();
            this.hasEnableIPLogging = forumPortlet.isEnableIPLogging();
        }
        return this.userProfile;
    }

    public void setUserName(String userId) {
        this.userName = userId;
        this.strOrderBy = "createdDate descending";
    }

    private String getTitleInHTMLCode(String s) {
        return ForumTransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    private List<Post> getPostsByUser() throws Exception {
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        List<Object> posts = null;
        try {
            boolean isMod = false;
            if (this.userProfile.getUserRole() < 2L) {
                isMod = true;
            }
            JCRPageList pageList = this.forumService.getPagePostByUser(this.userName, this.userProfile.getUserId(), isMod, this.strOrderBy);
            forumPageIterator.updatePageList(pageList);
            if (pageList != null) {
                pageList.setPageSize(6);
            }
            posts = pageList.getPage(forumPageIterator.getPageSelected());
            forumPageIterator.setSelectPage((long)pageList.getCurrentPage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (posts == null) {
            posts = new ArrayList<Post>();
        }
        this.posts = posts;
        return posts;
    }

    private Post getPostById(String postId) throws Exception {
        for (Post post : this.posts) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        Post post = (Post)this.forumService.getObjectNameById(postId, Utils.POST);
        return post;
    }

    static /* synthetic */ Post access$000(UIPageListPostByUser x0, String x1) throws Exception {
        return x0.getPostById(x1);
    }

    static /* synthetic */ UserProfile access$100(UIPageListPostByUser x0) {
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$200(UIPageListPostByUser x0) {
        return x0.forumService;
    }

    static /* synthetic */ String access$300(UIPageListPostByUser x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$302(UIPageListPostByUser x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

