/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(template="app:/templates/forum/webui/UIForumActionBar.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddForumActionListener.class}), @EventConfig(listeners={ManageModeratorActionListener.class}), @EventConfig(listeners={EditProfileActionListener.class}), @EventConfig(listeners={OpenBookMarkActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={ModerationActionListener.class}), @EventConfig(listeners={ImportCategoryActionListener.class}), @EventConfig(listeners={ExportCategoryActionListener.class}), @EventConfig(listeners={SortSettingActionListener.class}), @EventConfig(listeners={CensorKeywordActionListener.class}), @EventConfig(listeners={NotificationActionListener.class}), @EventConfig(listeners={BBCodeManagerActionListener.class}), @EventConfig(listeners={AutoPruneActionListener.class}), @EventConfig(listeners={TopicTypeManagerActionListener.class}), @EventConfig(listeners={OpenIPBanActionListener.class})})
public class UIForumActionBar
extends UIContainer {
    private UserProfile userProfile;
    private ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    private static final Log log = ExoLogger.getLogger(UIForumActionBar.class);

    private UserProfile getUserProfile() throws Exception {
        this.userProfile = ((UIForumPortlet)this.getParent()).getUserProfile();
        return this.userProfile;
    }

    private String[] getActionMenu() throws Exception {
        String[] stringArray;
        if (ForumUtils.enableIPLogging()) {
            String[] stringArray2 = new String[9];
            stringArray2[0] = "SortSetting";
            stringArray2[1] = "CensorKeyword";
            stringArray2[2] = "Notification";
            stringArray2[3] = "BBCodeManager";
            stringArray2[4] = "AutoPrune";
            stringArray2[5] = "TopicTypeManager";
            stringArray2[6] = "OpenIPBan";
            stringArray2[7] = "ExportCategory";
            stringArray = stringArray2;
            stringArray2[8] = "ImportCategory";
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = "SortSetting";
            stringArray3[1] = "CensorKeyword";
            stringArray3[2] = "Notification";
            stringArray3[3] = "BBCodeManager";
            stringArray3[4] = "AutoPrune";
            stringArray3[5] = "TopicTypeManager";
            stringArray3[6] = "ExportCategory";
            stringArray = stringArray3;
            stringArray3[7] = "ImportCategory";
        }
        return stringArray;
    }

    private int getTotalJobWattingForModerator() throws Exception {
        return this.forumService.getJobWattingForModeratorByUser(this.userProfile.getUserId());
    }

    private long getNewMessage() throws Exception {
        try {
            String username = this.userProfile.getUserId();
            return this.forumService.getNewPrivateMessage(username);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }

    public String getUserToken() throws Exception {
        try {
            ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
            return continuation.getUserToken(this.userProfile.getUserId());
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve continuation token for user " + this.userProfile.getUserId() + ": " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    static /* synthetic */ UserProfile access$000(UIForumActionBar x0) {
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$100(UIForumActionBar x0) {
        return x0.forumService;
    }
}

