/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPollForm;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.webui.UIFormMultiValueInputSet;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPollForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPollForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_QUESTION_INPUT = "Question";
    public static final String FIELD_OPTIONS = "Option";
    public static final String FIELD_TIMEOUT_INPUT = "TimeOut";
    public static final String FIELD_AGAINVOTE_CHECKBOX = "VoteAgain";
    public static final String FIELD_MULTIVOTE_CHECKBOX = "MultiVote";
    public static final int MAX_TITLE = 100;
    private UIFormMultiValueInputSet uiFormMultiValue = new UIFormMultiValueInputSet("Option", "Option");
    private String TopicPath;
    private Poll poll = new Poll();
    private boolean isUpdate = false;

    public UIPollForm() throws Exception {
        UIFormStringInput question = new UIFormStringInput(FIELD_QUESTION_INPUT, FIELD_QUESTION_INPUT, null);
        UIFormStringInput timeOut = new UIFormStringInput(FIELD_TIMEOUT_INPUT, FIELD_TIMEOUT_INPUT, null);
        timeOut.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        UIFormCheckBoxInput VoteAgain = new UIFormCheckBoxInput(FIELD_AGAINVOTE_CHECKBOX, FIELD_AGAINVOTE_CHECKBOX, (Object)false);
        UIFormCheckBoxInput MultiVote = new UIFormCheckBoxInput(FIELD_MULTIVOTE_CHECKBOX, FIELD_MULTIVOTE_CHECKBOX, (Object)false);
        this.addUIFormInput((UIFormInput)question);
        this.addUIFormInput((UIFormInput)timeOut);
        this.addUIFormInput((UIFormInput)VoteAgain);
        this.addUIFormInput((UIFormInput)MultiVote);
        this.setDefaulFall();
    }

    private void initMultiValuesField(List<String> list) throws Exception {
        if (this.uiFormMultiValue != null) {
            this.removeChildById(FIELD_OPTIONS);
        }
        this.uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        this.uiFormMultiValue.setId(FIELD_OPTIONS);
        this.uiFormMultiValue.setName(FIELD_OPTIONS);
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        this.uiFormMultiValue.setValue(list);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
    }

    public void setTopicPath(String topicPath) {
        this.TopicPath = topicPath;
    }

    private String getDateAfter() throws Exception {
        Date date = new Date();
        if (this.poll != null && this.poll.getTimeOut() > 0L) {
            date = this.poll.getModifiedDate();
        }
        String format = "MM-dd-yyyy";
        try {
            format = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile().getShortDateFormat();
        }
        catch (NullPointerException e) {
            format = this.getForumService().getDefaultUserProfile(UserHelper.getCurrentUser(), null).getShortDateFormat();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ForumUtils.getFormatDate((String)format, (Date)date);
    }

    public void setUpdatePoll(Poll poll, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.poll = poll;
            this.getUIStringInput(FIELD_QUESTION_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)poll.getQuestion()));
            this.getUIStringInput(FIELD_TIMEOUT_INPUT).setValue((Object)String.valueOf(poll.getTimeOut()));
            this.getUIFormCheckBoxInput(FIELD_AGAINVOTE_CHECKBOX).setChecked(poll.getIsAgainVote());
            UIFormCheckBoxInput multiVoteCheckInput = this.getUIFormCheckBoxInput(FIELD_MULTIVOTE_CHECKBOX);
            multiVoteCheckInput.setChecked(poll.getIsMultiCheck());
            multiVoteCheckInput.setEnable(false);
            this.isUpdate = isUpdate;
            this.setDefaulFall();
        }
    }

    private void setDefaulFall() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isUpdate) {
            for (String string : this.poll.getOption()) {
                list.add(ForumTransformHTML.unCodeHTML((String)string));
            }
        } else {
            list.add("");
            list.add("");
        }
        this.initMultiValuesField(list);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ void access$000(UIPollForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ UIFormMultiValueInputSet access$100(UIPollForm x0) {
        return x0.uiFormMultiValue;
    }

    static /* synthetic */ void access$200(UIPollForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$300(UIPollForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ boolean access$400(UIPollForm x0) {
        return x0.isUpdate;
    }

    static /* synthetic */ Poll access$500(UIPollForm x0) {
        return x0.poll;
    }

    static /* synthetic */ String access$600(UIPollForm x0) {
        return x0.TopicPath;
    }

    static /* synthetic */ ForumService access$700(UIPollForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$800(UIPollForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ boolean access$402(UIPollForm x0, boolean x1) {
        x0.isUpdate = x1;
        return x0.isUpdate;
    }

    static /* synthetic */ void access$900(UIPollForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$1000(UIPollForm x0, List x1) throws Exception {
        x0.initMultiValuesField(x1);
    }
}

