/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UICategory;
import org.exoplatform.forum.webui.UICategoryContainer;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumContainer;
import org.exoplatform.forum.webui.UIForumDescription;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UISearchForm;
import org.exoplatform.forum.webui.UITopicContainer;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.forum.webui.UITopicDetailContainer;
import org.exoplatform.forum.webui.UITopicPoll;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.forum.webui.popup.UIPostForm;
import org.exoplatform.forum.webui.popup.UISettingEditModeForm;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/forum/webui/UIForumPortlet.gtmpl", events={@EventConfig(listeners={ReLoadPortletEventActionListener.class}), @EventConfig(listeners={ViewPublicUserInfoActionListener.class}), @EventConfig(listeners={ViewPostedByUserActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={ViewThreadByUserActionListener.class}), @EventConfig(listeners={OpenLinkActionListener.class})})
public class UIForumPortlet
extends UIPortletApplication {
    private ForumService forumService;
    private boolean isCategoryRendered = true;
    private boolean isForumRendered = false;
    private boolean isTagRendered = false;
    private boolean isSearchRendered = false;
    private boolean isJumpRendered = false;
    private boolean isShowForumJump = false;
    private boolean isShowPoll = false;
    private boolean isShowModerators = false;
    private boolean isShowRules = false;
    private boolean isShowIconsLegend = false;
    private boolean isShowStatistics = false;
    private boolean isShowQuickReply = false;
    private UserProfile userProfile = null;
    private boolean enableIPLogging = false;
    private boolean isShowForumActionBar = false;
    private boolean enableBanIP = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private List<String> invisibleForums = new ArrayList();
    private List<String> invisibleCategories = new ArrayList();
    private List<Watch> listWatches = null;

    public UIForumPortlet() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIBreadcumbs.class, null, null);
        boolean isRenderBar = !UserHelper.isAnonim();
        ((UIForumActionBar)this.addChild(UIForumActionBar.class, null, null)).setRendered(isRenderBar);
        ((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
        ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
        ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
        ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
        UIPopupAction popupAction = (UIPopupAction)this.addChild(UIPopupAction.class, null, "UIForumPopupAction");
        ((UIPopupWindow)popupAction.getChild(UIPopupWindow.class)).setId("UIForumPopupWindow");
        try {
            this.loadPreferences();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            if (this.getChild(UIBreadcumbs.class) == null) {
                if (this.getChild(UISettingEditModeForm.class) != null) {
                    this.removeChild(UISettingEditModeForm.class);
                }
                this.addChild(UIBreadcumbs.class, null, null);
                ((UIForumActionBar)this.addChild(UIForumActionBar.class, null, null)).setRendered(!UserHelper.isAnonim());
                UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.addChild(UICategoryContainer.class, null, null)).setRendered(this.isCategoryRendered);
                ((UIForumContainer)this.addChild(UIForumContainer.class, null, null)).setRendered(this.isForumRendered);
                ((UITopicsTag)this.addChild(UITopicsTag.class, null, null)).setRendered(this.isTagRendered);
                ((UISearchForm)this.addChild(UISearchForm.class, null, null)).setRendered(this.isSearchRendered);
                ((UIForumLinks)this.addChild(UIForumLinks.class, null, null)).setRendered(this.isJumpRendered);
                this.updateIsRendered(ForumUtils.CATEGORIES);
                categoryContainer.updateIsRender(true);
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT && this.getChild(UISettingEditModeForm.class) == null) {
            UISettingEditModeForm editModeForm = (UISettingEditModeForm)this.addChild(UISettingEditModeForm.class, null, null);
            editModeForm.setUserProfile(this.getUserProfile());
            if (this.getChild(UIBreadcumbs.class) != null) {
                this.removeChild(UIBreadcumbs.class);
                this.removeChild(UIForumActionBar.class);
                this.removeChild(UICategoryContainer.class);
                this.removeChild(UIForumContainer.class);
                this.removeChild(UITopicsTag.class);
                this.removeChild(UISearchForm.class);
                this.removeChild(UIForumLinks.class);
            }
        }
        try {
            this.renderComponentByURL(context);
        }
        catch (Exception e) {
            log.error((Object)"Can not open component by url, view exception: ", (Throwable)e);
        }
        super.processRender(app, context);
    }

    public void renderComponentByURL(WebuiRequestContext context) throws Exception {
        String url;
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String old = url = portalContext.getRequest().getRequestURL().toString();
        String isAjax = portalContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            return;
        }
        String portalName = Util.getUIPortal().getName();
        String string = url = url.contains(portalName) ? url.substring(url.lastIndexOf(portalName)) : url;
        String string2 = url.contains(org.exoplatform.forum.service.Utils.FORUM_SERVICE) ? url.substring(url.lastIndexOf(org.exoplatform.forum.service.Utils.FORUM_SERVICE)) : (url.contains(org.exoplatform.forum.service.Utils.CATEGORY) ? url.substring(url.lastIndexOf(org.exoplatform.forum.service.Utils.CATEGORY)) : (url.contains(org.exoplatform.forum.service.Utils.TOPIC) ? url.substring(url.lastIndexOf(org.exoplatform.forum.service.Utils.TOPIC)) : (url = url.contains(org.exoplatform.forum.service.Utils.FORUM) && url.lastIndexOf(org.exoplatform.forum.service.Utils.FORUM) + 5 < url.length() ? url.substring(url.lastIndexOf(org.exoplatform.forum.service.Utils.FORUM)) : url)));
        if (url.indexOf(portalName) >= 0) {
            return;
        }
        if (url.equals(old)) {
            if (this.getForumIdOfSpace() != null) {
                url = this.getForumIdOfSpace();
            } else {
                return;
            }
        }
        this.calculateRenderComponent(url, context);
        context.addUIComponentToUpdateByAjax((UIComponent)this);
    }

    private String getForumIdOfSpace() {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            if (pref.getValue("SPACE_URL", null) != null) {
                String url = pref.getValue("SPACE_URL", null);
                SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                Space space = sService.getSpaceByUrl(url);
                String forumId = org.exoplatform.forum.service.Utils.FORUM + space.getId();
                return forumId;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateIsRendered(String selected) throws Exception {
        if (selected.equals(ForumUtils.CATEGORIES)) {
            this.isCategoryRendered = true;
            this.isForumRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected.equals(ForumUtils.FORUM)) {
            this.isForumRendered = true;
            this.isCategoryRendered = false;
            this.isTagRendered = false;
            this.isSearchRendered = false;
        } else if (selected.equals(ForumUtils.TAG)) {
            this.isTagRendered = true;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = false;
        } else {
            this.isTagRendered = false;
            this.isForumRendered = false;
            this.isCategoryRendered = false;
            this.isSearchRendered = true;
        }
        if (!(this.isShowForumActionBar || this.isCategoryRendered && !this.isSearchRendered)) {
            ((UIForumActionBar)this.getChild(UIForumActionBar.class)).setRendered(false);
        }
        this.setRenderForumLink();
        ((UIForumContainer)this.getChild(UIForumContainer.class)).setRendered(this.isForumRendered);
        ((UITopicsTag)this.getChild(UITopicsTag.class)).setRendered(this.isTagRendered);
        ((UISearchForm)this.getChild(UISearchForm.class)).setRendered(this.isSearchRendered);
        if (!this.isForumRendered) {
            try {
                this.setRenderQuickReply();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setRenderForumLink() throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        this.isJumpRendered = this.isShowForumJump ? this.userProfile.getIsShowForumJump() : false;
        UICategoryContainer categoryContainer = (UICategoryContainer)((UICategoryContainer)this.getChild(UICategoryContainer.class)).setRendered(this.isCategoryRendered);
        categoryContainer.setIsRenderJump(this.isJumpRendered);
        if (!this.isCategoryRendered) {
            ((UIForumLinks)this.getChild(UIForumLinks.class)).setRendered(this.isJumpRendered);
        }
    }

    public void setRenderQuickReply() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        ActionResponse actionRes = (ActionResponse)pcontext.getResponse();
        ForumParameter param = new ForumParameter();
        param.setRenderQuickReply(false);
        param.setRenderPoll(false);
        param.setRenderModerator(false);
        param.setRenderRule(false);
        actionRes.setEvent(new QName("QuickReplyEvent"), (Serializable)param);
        actionRes.setEvent(new QName("ForumPollEvent"), (Serializable)param);
        actionRes.setEvent(new QName("ForumModerateEvent"), (Serializable)param);
        actionRes.setEvent(new QName("ForumRuleEvent"), (Serializable)param);
    }

    public void loadPreferences() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        this.invisibleCategories.clear();
        this.invisibleForums.clear();
        try {
            this.isShowForumActionBar = Boolean.parseBoolean(portletPref.getValue("showForumActionBar", ""));
            this.dayForumNewPost = Integer.parseInt(portletPref.getValue("forumNewPost", ""));
            this.useAjax = Boolean.parseBoolean(portletPref.getValue("useAjax", ""));
            this.enableIPLogging = Boolean.parseBoolean(portletPref.getValue("enableIPLogging", ""));
            this.enableBanIP = Boolean.parseBoolean(portletPref.getValue("enableIPFiltering", ""));
            this.isShowForumJump = Boolean.parseBoolean(portletPref.getValue("isShowForumJump", ""));
            this.isShowPoll = Boolean.parseBoolean(portletPref.getValue("isShowPoll", ""));
            this.isShowModerators = Boolean.parseBoolean(portletPref.getValue("isShowModerators", ""));
            this.isShowRules = Boolean.parseBoolean(portletPref.getValue("isShowRules", ""));
            this.isShowQuickReply = Boolean.parseBoolean(portletPref.getValue("isShowQuickReply", ""));
            this.isShowStatistics = Boolean.parseBoolean(portletPref.getValue("isShowStatistics", ""));
            this.isShowIconsLegend = Boolean.parseBoolean(portletPref.getValue("isShowIconsLegend", ""));
            this.invisibleCategories.addAll(this.getListInValus(portletPref.getValue("invisibleCategories", "")));
            this.invisibleForums.addAll(this.getListInValus(portletPref.getValue("invisibleForums", "")));
        }
        catch (Exception e) {
            log.error((Object)("Fail to load preference: " + e.getCause()));
        }
        if (this.invisibleCategories.size() == 1 && ((String)this.invisibleCategories.get(0)).equals(" ")) {
            this.invisibleCategories.clear();
        }
    }

    private List<String> getListInValus(String value) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (!ForumUtils.isEmpty((String)value)) {
            list.addAll(Arrays.asList(ForumUtils.addStringToString((String)value, (String)value)));
        }
        return list;
    }

    public List<String> getInvisibleForums() {
        return this.invisibleForums;
    }

    public List<String> getInvisibleCategories() {
        return this.invisibleCategories;
    }

    public boolean isEnableIPLogging() {
        return this.enableIPLogging;
    }

    public boolean isEnableBanIp() {
        return this.enableBanIP;
    }

    public boolean isShowForumActionBar() {
        return this.isShowForumActionBar;
    }

    public boolean isShowPoll() {
        return this.isShowPoll;
    }

    public boolean isShowModerators() {
        return this.isShowModerators;
    }

    public boolean isShowRules() {
        return this.isShowRules;
    }

    public boolean isShowIconsLegend() {
        return this.isShowIconsLegend;
    }

    public boolean isShowQuickReply() {
        return this.isShowQuickReply;
    }

    public boolean isShowStatistics() {
        return this.isShowStatistics;
    }

    public boolean isUseAjax() {
        return this.useAjax;
    }

    public int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        return this.userProfile;
    }

    public void updateWatchinh() throws Exception {
        this.listWatches = this.forumService.getWatchByUser(this.userProfile.getUserId());
    }

    public List<Watch> getWatchinhByCurrentUser() throws Exception {
        if (this.listWatches == null) {
            this.updateWatchinh();
        }
        return this.listWatches;
    }

    public void updateAccessTopic(String topicId) throws Exception {
        String userId = this.userProfile.getUserId();
        if (userId != null && userId.length() > 0) {
            try {
                this.forumService.updateTopicAccess(userId, topicId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.userProfile.setLastTimeAccessTopic(topicId, ForumUtils.getInstanceTempCalendar().getTimeInMillis());
    }

    public void updateAccessForum(String forumId) throws Exception {
        String userId = this.userProfile.getUserId();
        if (userId != null && userId.length() > 0) {
            try {
                this.forumService.updateForumAccess(userId, forumId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.userProfile.setLastTimeAccessForum(forumId, ForumUtils.getInstanceTempCalendar().getTimeInMillis());
    }

    public void updateUserProfileInfo() throws Exception {
        String userId = "";
        try {
            userId = UserHelper.getCurrentUser();
        }
        catch (Exception e) {
            log.error((Object)("user is unknown: " + e.getCause()));
        }
        try {
            this.userProfile = this.enableBanIP ? this.forumService.getDefaultUserProfile(userId, Utils.getRemoteIP()) : this.forumService.getDefaultUserProfile(userId, null);
            if (!ForumUtils.isEmpty((String)userId)) {
                this.userProfile.setEmail(UserHelper.getUserByUserId((String)userId).getEmail());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CommonContact getPersonalContact(String userId) throws Exception {
        CommonContact contact = ForumSessionUtils.getPersonalContact((String)userId);
        if (contact == null) {
            contact = new CommonContact();
        }
        return contact;
    }

    private boolean isInArray(String[] arr, String str) {
        return Arrays.asList(arr).contains(str);
    }

    private boolean isArrayNotNull(String[] strs) {
        return strs != null && strs.length > 0 && !strs[0].equals(" ");
    }

    public boolean checkCanView(Category cate, Forum forum, Topic topic) throws Exception {
        if (this.userProfile == null) {
            this.updateUserProfileInfo();
        }
        String userId = this.userProfile.getUserId();
        if (this.userProfile.getUserRole() == 0L) {
            return true;
        }
        List userBound = UserHelper.getAllGroupAndMembershipOfUser((String)userId);
        String[] viewer = cate.getUserPrivate();
        if (this.isArrayNotNull(viewer) && !org.exoplatform.forum.service.Utils.hasPermission(Arrays.asList(viewer), (List)userBound)) {
            return false;
        }
        if (forum != null) {
            if (this.isArrayNotNull(forum.getModerators())) {
                if (org.exoplatform.forum.service.Utils.hasPermission(Arrays.asList(forum.getModerators()), (List)userBound)) {
                    return true;
                }
            } else if (forum.getIsClosed()) {
                return false;
            }
        }
        if (topic != null) {
            List<String> list = new ArrayList();
            list = ForumUtils.addArrayToList(list, (String[])topic.getCanView());
            list = ForumUtils.addArrayToList(list, (String[])forum.getViewer());
            if (!(list = ForumUtils.addArrayToList(list, (String[])cate.getViewer())).isEmpty() && topic.getOwner() != null) {
                list.add(topic.getOwner());
            }
            if (topic.getIsClosed() || !topic.getIsActive() || !topic.getIsActiveByForum() || !topic.getIsApproved() || topic.getIsWaiting() || !list.isEmpty() && !org.exoplatform.forum.service.Utils.hasPermission(list, (List)userBound)) {
                return false;
            }
        }
        return true;
    }

    public void calculateRenderComponent(String path, WebuiRequestContext context) throws Exception {
        block46: {
            UIForumPortlet uiApp = this;
            ResourceBundle res = context.getApplicationResourceBundle();
            if (path.equals(org.exoplatform.forum.service.Utils.FORUM_SERVICE)) {
                this.updateIsRendered(ForumUtils.CATEGORIES);
                UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                categoryContainer.updateIsRender(true);
                ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
            } else if (path.lastIndexOf(org.exoplatform.forum.service.Utils.TOPIC) >= 0) {
                boolean isReply = false;
                boolean isQuote = false;
                if (path.indexOf("/true") > 0) {
                    isQuote = true;
                    path = path.replaceFirst("/true", "");
                } else if (path.indexOf("/false") > 0) {
                    isReply = true;
                    path = path.replaceFirst("/false", "");
                }
                String[] id = path.split("/");
                String postId = "top";
                int page = 0;
                if (path.indexOf(org.exoplatform.forum.service.Utils.POST) > 0) {
                    postId = id[id.length - 1];
                    path = path.substring(0, path.lastIndexOf("/"));
                    id = new String[]{path};
                } else if (id.length > 1) {
                    try {
                        page = Integer.parseInt(id[id.length - 1]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (page > 0) {
                        path = path.replace("/" + id[id.length - 1], "");
                        id = new String[]{path};
                    } else {
                        page = 0;
                    }
                }
                try {
                    Forum forum;
                    Topic topic;
                    if (id.length > 1) {
                        topic = this.forumService.getTopicByPath(path, false);
                    } else {
                        topic = (Topic)this.forumService.getObjectNameById(path, org.exoplatform.forum.service.Utils.TOPIC);
                        path = topic.getPath();
                        path = path.substring(path.indexOf(org.exoplatform.forum.service.Utils.CATEGORY));
                        id = path.split("/");
                    }
                    if (topic == null) break block46;
                    Category category = this.forumService.getCategory(id[0]);
                    if (this.checkCanView(category, forum = this.forumService.getForum(id[0], id[1]), topic)) {
                        this.updateIsRendered(ForumUtils.FORUM);
                        UIForumContainer uiForumContainer = (UIForumContainer)this.getChild(UIForumContainer.class);
                        UITopicDetailContainer uiTopicDetailContainer = (UITopicDetailContainer)uiForumContainer.getChild(UITopicDetailContainer.class);
                        uiForumContainer.setIsRenderChild(false);
                        ((UIForumDescription)uiForumContainer.getChild(UIForumDescription.class)).setForum(forum);
                        UITopicDetail uiTopicDetail = (UITopicDetail)uiTopicDetailContainer.getChild(UITopicDetail.class);
                        uiTopicDetail.setIsEditTopic(true);
                        uiTopicDetail.setUpdateForum(forum);
                        uiTopicDetail.setTopicFromCate(id[0], id[1], topic, page);
                        ((UITopicPoll)uiTopicDetailContainer.getChild(UITopicPoll.class)).updateFormPoll(id[0], id[1], topic.getId());
                        ((UIForumLinks)this.getChild(UIForumLinks.class)).setValueOption(id[0] + "/" + id[1] + " ");
                        uiTopicDetail.setIdPostView(postId);
                        if (isReply || isQuote) {
                            if (uiTopicDetail.getCanPost()) {
                                uiTopicDetail.setIdPostView("top");
                                try {
                                    UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
                                    UIPopupContainer popupContainer = (UIPopupContainer)popupAction.createUIComponent(UIPopupContainer.class, null, null);
                                    UIPostForm postForm = (UIPostForm)popupContainer.addChild(UIPostForm.class, null, null);
                                    boolean isMod = ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)this.userProfile.getUserId());
                                    postForm.setPostIds(id[0], id[1], topic.getId(), topic);
                                    postForm.setMod(isMod);
                                    if (isQuote) {
                                        uiTopicDetail.setLastPostId(postId);
                                        Post post = this.forumService.getPost(id[0], id[1], topic.getId(), postId);
                                        if (post != null) {
                                            postForm.updatePost(postId, true, false, post);
                                            popupContainer.setId("UIQuoteContainer");
                                        } else {
                                            uiApp.addMessage(new ApplicationMessage("UIBreadcumbs.msg.post-no-longer-exist", null, 1));
                                            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                                            uiTopicDetail.setIdPostView("normal");
                                        }
                                    } else {
                                        postForm.updatePost("", false, false, null);
                                        popupContainer.setId("UIAddPostContainer");
                                    }
                                    popupAction.activate((UIComponent)popupContainer, 900, 500);
                                    context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
                                }
                                catch (Exception e) {
                                    log.error((Object)e);
                                }
                            } else {
                                uiApp.addMessage(new ApplicationMessage("UIPostForm.msg.no-permission", null, 1));
                            }
                        }
                        if (!UserHelper.isAnonim()) {
                            this.forumService.updateTopicAccess(UserHelper.getCurrentUser(), topic.getId());
                            this.getUserProfile().setLastTimeAccessTopic(topic.getId(), ForumUtils.getInstanceTempCalendar().getTimeInMillis());
                        }
                        break block46;
                    }
                    uiApp.addMessage(new ApplicationMessage("UIBreadcumbs.msg.do-not-permission", (Object[])new String[]{topic.getTopicName(), res.getString("UIForumPortlet.label.topic").toLowerCase()}, 1));
                    this.updateIsRendered(ForumUtils.CATEGORIES);
                    UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                    categoryContainer.updateIsRender(true);
                    ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                    path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    uiApp.addMessage(new ApplicationMessage("UIShowBookMarkForm.msg.link-not-found", null, 1));
                    this.updateIsRendered(ForumUtils.CATEGORIES);
                    UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                    categoryContainer.updateIsRender(true);
                    ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                    path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
                }
            } else if (path.lastIndexOf(org.exoplatform.forum.service.Utils.FORUM) == 0 && path.lastIndexOf(org.exoplatform.forum.service.Utils.CATEGORY) < 0 || path.lastIndexOf(org.exoplatform.forum.service.Utils.FORUM) > 0) {
                UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                try {
                    Forum forum;
                    String cateId = null;
                    int page = 0;
                    if (path.indexOf("/") > 0) {
                        String[] arr = path.split("/");
                        try {
                            page = Integer.parseInt(arr[arr.length - 1]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (arr[0].indexOf(org.exoplatform.forum.service.Utils.CATEGORY) == 0) {
                            cateId = arr[0];
                            forum = this.forumService.getForum(cateId, arr[1]);
                        } else {
                            forum = (Forum)this.forumService.getObjectNameById(arr[0], org.exoplatform.forum.service.Utils.FORUM);
                        }
                    } else {
                        forum = (Forum)this.forumService.getObjectNameById(path, org.exoplatform.forum.service.Utils.FORUM);
                    }
                    path = forum.getPath();
                    if (cateId == null) {
                        cateId = path.substring(path.indexOf(org.exoplatform.forum.service.Utils.CATEGORY), path.lastIndexOf(org.exoplatform.forum.service.Utils.FORUM) - 1);
                    }
                    path = path.substring(path.indexOf(org.exoplatform.forum.service.Utils.CATEGORY));
                    Category category = this.forumService.getCategory(cateId);
                    if (this.checkCanView(category, forum, null)) {
                        this.updateIsRendered(ForumUtils.FORUM);
                        UIForumContainer forumContainer = (UIForumContainer)this.findFirstComponentOfType(UIForumContainer.class);
                        forumContainer.setIsRenderChild(true);
                        ((UIForumDescription)forumContainer.getChild(UIForumDescription.class)).setForum(forum);
                        ((UITopicContainer)forumContainer.getChild(UITopicContainer.class)).setUpdateForum(cateId, forum, page);
                        break block46;
                    }
                    uiApp.addMessage(new ApplicationMessage("UIBreadcumbs.msg.do-not-permission", (Object[])new String[]{forum.getForumName(), res.getString("UIForumPortlet.label.forum").toLowerCase()}, 1));
                    this.updateIsRendered(ForumUtils.CATEGORIES);
                    categoryContainer.updateIsRender(true);
                    ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                    path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIShowBookMarkForm.msg.link-not-found", (Object[])new String[]{res.getString("UIForumPortlet.label.forum")}, 1));
                    this.updateIsRendered(ForumUtils.CATEGORIES);
                    categoryContainer.updateIsRender(true);
                    ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                    path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
                }
            } else if (path.indexOf(org.exoplatform.forum.service.Utils.CATEGORY) >= 0 && path.indexOf("/") < 0) {
                UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                try {
                    Category category = this.forumService.getCategory(path);
                    if (this.checkCanView(category, null, null)) {
                        ((UICategory)categoryContainer.getChild(UICategory.class)).updateByLink(category);
                        categoryContainer.updateIsRender(false);
                        this.updateIsRendered(ForumUtils.CATEGORIES);
                        break block46;
                    }
                    uiApp.addMessage(new ApplicationMessage("UIBreadcumbs.msg.do-not-permission", (Object[])new String[]{category.getCategoryName(), res.getString("UIForumPortlet.label.category").toLowerCase()}, 1));
                    this.updateIsRendered(ForumUtils.CATEGORIES);
                    categoryContainer.updateIsRender(true);
                    ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                    path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIShowBookMarkForm.msg.link-not-found", null, 1));
                    this.updateIsRendered(ForumUtils.CATEGORIES);
                    categoryContainer.updateIsRender(true);
                    ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                    path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIShowBookMarkForm.msg.link-not-found", null, 1));
                this.updateIsRendered(ForumUtils.CATEGORIES);
                UICategoryContainer categoryContainer = (UICategoryContainer)this.getChild(UICategoryContainer.class);
                categoryContainer.updateIsRender(true);
                ((UICategories)categoryContainer.getChild(UICategories.class)).setIsRenderChild(false);
                path = org.exoplatform.forum.service.Utils.FORUM_SERVICE;
            }
        }
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.findFirstComponentOfType(UIBreadcumbs.class);
        uiBreadcumbs.setUpdataPath(path);
        ((UIForumLinks)this.getChild(UIForumLinks.class)).setValueOption(path);
    }

    static /* synthetic */ UserProfile access$000(UIForumPortlet x0) {
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$100(UIForumPortlet x0) {
        return x0.forumService;
    }

    static /* synthetic */ Log access$200() {
        return log;
    }

    static /* synthetic */ CommonContact access$300(UIForumPortlet x0, String x1) throws Exception {
        return x0.getPersonalContact(x1);
    }
}

