/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UICategoryInfo;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UICategoryInfo.gtmpl", events={@EventConfig(listeners={CreatedLinkActionListener.class})})
public class UICategoryInfo
extends UIContainer {
    private ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    private UserProfile userProfile;

    private List<String> getUserOnline() throws Exception {
        return this.forumService.getOnlineUsers();
    }

    private String getScreenName(String userName) throws Exception {
        return this.forumService.getScreenName(userName);
    }

    private UserProfile getUserProfile() throws Exception {
        try {
            UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
            this.userProfile = forumPortlet.getUserProfile();
        }
        catch (Exception e) {
            String userId = UserHelper.getCurrentUser();
            this.userProfile = this.forumService.getDefaultUserProfile(userId, "");
        }
        return this.userProfile;
    }

    private String getMostUsersOnline(String s, String at) throws Exception {
        if (ForumUtils.isEmpty((String)s)) {
            return "";
        }
        try {
            String[] strs = s.split(",");
            long l = Long.parseLong(strs[1].replace("at", "").trim());
            Calendar calendar = GregorianCalendar.getInstance();
            double timeZone = this.userProfile.getTimeZone();
            if (this.userProfile.getUserId().equals("user_gest_uoom")) {
                timeZone = 0.0;
            }
            long zone = (long)(timeZone * 3600000.0);
            calendar.setTimeInMillis(l - zone);
            StringBuilder builder = new StringBuilder();
            if (ForumUtils.isEmpty((String)at)) {
                at = "at";
            }
            builder.append(strs[0]).append(", ").append(at).append(" ");
            builder.append(ForumUtils.getFormatDate((String)(this.userProfile.getLongDateFormat() + ", " + this.userProfile.getTimeFormat()), (Date)calendar.getTime()));
            if (this.userProfile.getUserId().equals(3L)) {
                if (timeZone >= 0.0) {
                    builder.append(" GMT+").append(String.valueOf(timeZone).replace(".0", ""));
                } else {
                    builder.append(" GMT").append(String.valueOf(timeZone).replace(".0", ""));
                }
            }
            s = builder.toString();
        }
        catch (Exception e) {
            s = s.replace("at", at);
        }
        return s;
    }

    public Calendar getInstanceTempCalendar() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() + (long)gmtoffset);
        return calendar;
    }

    public ForumStatistic getForumStatistic() throws Exception {
        return this.forumService.getForumStatistic();
    }
}

