/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumListSearch;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UIForumListSearch.gtmpl", events={@EventConfig(listeners={OpentContentActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIForumListSearch
extends UIContainer {
    private List<ForumSearch> listEvent = null;
    private boolean isShowIter = true;
    public final String SEARCH_ITERATOR = "forumSearchIterator";
    private JCRPageList pageList;
    private UIForumPageIterator pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "forumSearchIterator");

    public void setListSearchEvent(List<ForumSearch> listEvent) {
        this.listEvent = listEvent;
        this.pageIterator.setSelectPage(1L);
    }

    public boolean getIsShowIter() {
        return this.isShowIter;
    }

    public List<ForumSearch> getListEvent() {
        this.pageList = new ForumPageList(10, this.listEvent.size());
        this.pageList.setPageSize(10);
        this.pageIterator.updatePageList(this.pageList);
        this.isShowIter = true;
        if (this.pageList.getAvailablePage() <= 1) {
            this.isShowIter = false;
        }
        int pageSelect = this.pageIterator.getPageSelected();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        try {
            list.addAll(this.pageList.getPageSearch(pageSelect, this.listEvent));
        }
        catch (Exception exception) {
            // empty catch block
        }
        pageSelect = this.pageList.getCurrentPage();
        return list;
    }

    private ForumSearch getForumSearch(String id) {
        for (ForumSearch forumSearch : this.listEvent) {
            if (!forumSearch.getId().equals(id)) continue;
            return forumSearch;
        }
        return null;
    }

    private boolean canView(Category category, Forum forum, Topic topic, Post post, UserProfile userProfile) throws Exception {
        if (userProfile.getUserRole() == 0L) {
            return true;
        }
        boolean canView = true;
        boolean isModerator = false;
        if (category == null) {
            return false;
        }
        String[] listUsers = category.getUserPrivate();
        if (listUsers.length > 0 && listUsers[0].trim().length() > 0 && !ForumServiceUtils.hasPermission((String[])listUsers, (String)userProfile.getUserId())) {
            return false;
        }
        if (forum != null) {
            listUsers = forum.getModerators();
            if (userProfile.getUserRole() == 1L && listUsers.length > 0 && listUsers[0].trim().length() > 0 && ForumServiceUtils.hasPermission((String[])listUsers, (String)userProfile.getUserId())) {
                isModerator = true;
                canView = true;
            } else {
                if (forum.getIsClosed()) {
                    return false;
                }
                canView = true;
            }
            if (topic != null) {
                if (!isModerator && !topic.getIsClosed() && topic.getIsActive() && topic.getIsActiveByForum() && topic.getIsApproved() && !topic.getIsWaiting()) {
                    List<String> list = new ArrayList();
                    list = ForumUtils.addArrayToList(list, (String[])topic.getCanView());
                    list = ForumUtils.addArrayToList(list, (String[])forum.getViewer());
                    if (!(list = ForumUtils.addArrayToList(list, (String[])category.getViewer())).isEmpty()) {
                        list.add(topic.getOwner());
                    }
                    if (!list.isEmpty() && !ForumServiceUtils.hasPermission((String[])list.toArray(new String[0]), (String)userProfile.getUserId())) {
                        canView = false;
                    }
                } else {
                    canView = false;
                }
            }
        }
        return canView;
    }

    static /* synthetic */ ForumSearch access$000(UIForumListSearch x0, String x1) {
        return x0.getForumSearch(x1);
    }

    static /* synthetic */ boolean access$100(UIForumListSearch x0, Category x1, Forum x2, Topic x3, Post x4, UserProfile x5) throws Exception {
        return x0.canView(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ List access$200(UIForumListSearch x0) {
        return x0.listEvent;
    }
}

