/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIExportForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIExportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIExportForm
extends BaseForumForm
implements UIPopupComponent {
    public static final Log log = ExoLogger.getLogger(UIExportForm.class);
    private boolean isExportAll = false;
    private static final String LIST_CATEGORIES = "listCategories";
    private static final String CREATE_ZIP = "createZip";
    private static final String FILE_NAME = "FileName";
    private static String EXPORT_MODE = "ExportMode";
    private static String EXPORT_ALL = "ExportAll";
    private static String EXPORT_CATEGORIES = "ExportCategories";
    List<Object> listObjects = new ArrayList();
    private Object object_ = "";

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setObjectId(Object object) {
        this.object_ = object;
        this.setActions(new String[]{"Save", "Cancel"});
        if (object == null || object instanceof Category) {
            Category cat = (Category)object;
            UIFormCheckBoxInput checkBoxInput = null;
            try {
                UIFormInputWithActions formInputWithActions = new UIFormInputWithActions(LIST_CATEGORIES);
                if (cat == null) {
                    for (Category category : this.getForumService().getCategories()) {
                        this.listObjects.add(category);
                        checkBoxInput = new UIFormCheckBoxInput(category.getId(), category.getId(), (Object)true);
                        checkBoxInput.setChecked(true);
                        formInputWithActions.addChild((UIComponent)checkBoxInput);
                    }
                } else {
                    for (Forum forum : this.getForumService().getForums(cat.getId(), null)) {
                        this.listObjects.add(forum);
                        checkBoxInput = new UIFormCheckBoxInput(forum.getId(), forum.getId(), (Object)true);
                        checkBoxInput.setChecked(true);
                        formInputWithActions.addChild((UIComponent)checkBoxInput);
                    }
                }
                this.addChild((UIComponent)formInputWithActions);
            }
            catch (Exception e) {
                log.warn((Object)"failed to list forum categories", (Throwable)e);
            }
            UIFormStringInput stringInput = new UIFormStringInput(FILE_NAME, null);
            stringInput.setValue((Object)this.getLabel("DefaultFileName"));
            checkBoxInput = new UIFormCheckBoxInput(CREATE_ZIP, CREATE_ZIP, (Object)false);
            checkBoxInput.setChecked(true).setEnable(false);
            this.addChild((UIComponent)stringInput);
            this.addChild((UIComponent)checkBoxInput);
            if (object == null) {
                ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
                EXPORT_ALL = this.getLabel("ExportAll");
                EXPORT_CATEGORIES = this.getLabel("ExportCategories");
                EXPORT_MODE = this.getLabel("ExportMode");
                list.add(new SelectItemOption((Object)EXPORT_ALL));
                list.add(new SelectItemOption((Object)EXPORT_CATEGORIES));
                UIFormRadioBoxInput exportMode = new UIFormRadioBoxInput(EXPORT_MODE, EXPORT_MODE, list);
                exportMode.setValue((Object)EXPORT_CATEGORIES);
                this.addChild((UIComponent)exportMode);
            }
        } else {
            UIFormStringInput stringInput = new UIFormStringInput(FILE_NAME, null);
            stringInput.setValue((Object)this.getLabel("DefaultFileName"));
            this.addChild((UIComponent)stringInput);
            this.addChild((UIComponent)new UIFormCheckBoxInput(CREATE_ZIP, CREATE_ZIP, (Object)false));
        }
    }

    private List<String> getListSelected() {
        ArrayList<String> listId = new ArrayList<String>();
        List children = ((UIFormInputWithActions)this.getChildById(LIST_CATEGORIES)).getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UIFormCheckBoxInput) || !((UIFormCheckBoxInput)child).isChecked()) continue;
            listId.add(child.getName());
        }
        return listId;
    }

    static /* synthetic */ void access$000(UIExportForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ String access$100() {
        return EXPORT_MODE;
    }

    static /* synthetic */ String access$200() {
        return EXPORT_CATEGORIES;
    }

    static /* synthetic */ boolean access$302(UIExportForm x0, boolean x1) {
        x0.isExportAll = x1;
        return x0.isExportAll;
    }

    static /* synthetic */ Object access$400(UIExportForm x0) {
        return x0.object_;
    }

    static /* synthetic */ boolean access$300(UIExportForm x0) {
        return x0.isExportAll;
    }

    static /* synthetic */ List access$500(UIExportForm x0) {
        return x0.getListSelected();
    }

    static /* synthetic */ ForumService access$600(UIExportForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ void access$700(UIExportForm x0, String x1) {
        x0.warning(x1);
    }
}

