/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UISelectItemForum;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISelectItemForumForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISelectItemForum
extends BaseForumForm
implements UIPopupComponent {
    List<ForumLinkData> forumLinks = null;
    private Map<String, List<ForumLinkData>> mapListForum = new HashMap();
    private Map<String, List<ForumLinkData>> mapListTopic = new HashMap();
    private List<String> listIdIsSelected = new ArrayList();

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setForumLinks(List<String> listIds) throws Exception {
        UIForumLinks uiForumLinks = (UIForumLinks)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getChild(UIForumLinks.class);
        this.listIdIsSelected = new ArrayList();
        this.listIdIsSelected.addAll(listIds);
        if (uiForumLinks != null) {
            this.forumLinks = uiForumLinks.getForumLinks();
        }
        if (this.forumLinks == null || this.forumLinks.size() <= 0) {
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            this.forumLinks = forumService.getAllLink("", "");
        }
    }

    private List<ForumLinkData> getForumLinks() throws Exception {
        String categoryId = "";
        String forumId = "";
        boolean isPut = true;
        ArrayList<ForumLinkData> linkForum = new ArrayList<ForumLinkData>();
        ArrayList linkTopic = new ArrayList();
        String cateId = "";
        for (ForumLinkData forumLink : this.forumLinks) {
            if (!forumLink.getType().equals(Utils.CATEGORY)) continue;
            cateId = forumLink.getId();
            for (ForumLinkData forumlist : this.forumLinks) {
                if (!forumlist.getType().equals(Utils.FORUM) || forumlist.getPath().indexOf(cateId) < 0) continue;
                linkForum.add(forumlist);
                if (this.getUIFormCheckBoxInput(forumlist.getPath()) != null) continue;
                if (this.listIdIsSelected.contains(forumlist.getId())) {
                    this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(forumlist.getPath(), forumlist.getPath(), (Object)false).setChecked(true));
                    continue;
                }
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(forumlist.getPath(), forumlist.getPath(), (Object)false).setChecked(false));
            }
            this.mapListForum.put(cateId, linkForum);
            linkForum = new ArrayList();
        }
        return this.forumLinks;
    }

    private List<ForumLinkData> getForums(String categoryId) {
        return (List)this.mapListForum.get(categoryId);
    }

    private List<ForumLinkData> getTopics(String forumId) {
        return (List)this.mapListTopic.get(forumId);
    }

    private String getNameForumLinkData(String id) throws Exception {
        for (ForumLinkData linkData : this.forumLinks) {
            if (!linkData.getPath().equals(id)) continue;
            return linkData.getName();
        }
        return null;
    }

    static /* synthetic */ String access$000(UISelectItemForum x0, String x1) throws Exception {
        return x0.getNameForumLinkData(x1);
    }

    static /* synthetic */ void access$100(UISelectItemForum x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ void access$200(UISelectItemForum x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

