/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicsTag;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicsTag.gtmpl", events={@EventConfig(listeners={OpenTopicActionListener.class}), @EventConfig(listeners={RemoveTopicActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UITopicsTag
extends UIForumKeepStickPageIterator {
    private String tagId = "";
    private Tag tag;
    private boolean isUpdateTag = true;
    private String strOrderBy = "";
    private String userIdAndtagId;
    private String linkUserInfo = "";
    private UserProfile userProfile = null;
    private List<Watch> listWatches = new ArrayList();
    private List<Topic> topics = new ArrayList();
    private Map<String, Long> mapNumberPagePost = new HashMap();

    public void setIdTag(String tagId) throws Exception {
        this.tagId = tagId;
        this.isUpdateTag = true;
        this.mapNumberPagePost.clear();
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        this.listWatches = forumPortlet.getWatchingByCurrentUser();
        this.linkUserInfo = forumPortlet.getPortletLink();
        this.userIdAndtagId = !this.userProfile.getUserId().equals("user_gest_uoom") ? this.userProfile.getUserId() + ":" + tagId : tagId;
    }

    private String getActionViewInfoUser(String linkType, String userName) {
        String link = this.linkUserInfo.replace("ViewPublicUserInfo", linkType).replace("userName", userName);
        return link;
    }

    public void setTag(Tag tag, String userIdAndtagId) throws Exception {
        this.tag = tag;
        this.tagId = tag.getId();
        this.isUpdateTag = false;
        this.mapNumberPagePost.clear();
        this.userIdAndtagId = userIdAndtagId;
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        this.listWatches = forumPortlet.getWatchingByCurrentUser();
        this.linkUserInfo = forumPortlet.getPortletLink();
    }

    private UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
    }

    private String getScreenName(String userName) throws Exception {
        return this.getForumService().getScreenName(userName);
    }

    public String getRSSLink(String cateId) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return RSS.getRSSLink((String)"forum", (String)pcontainer.getPortalContainerInfo().getContainerName(), (String)cateId);
    }

    private String getTitleInHTMLCode(String s) {
        return ForumTransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    private long getSizePost(String Id) throws Exception {
        if (this.mapNumberPagePost.containsKey(Id)) {
            return (Long)this.mapNumberPagePost.get(Id);
        }
        String[] Ids = Id.split("/");
        Topic topic = this.getTopic(Ids[Ids.length - 1]);
        long maxPost = this.getUserProfile().getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        if (topic != null && topic.getPostCount() > maxPost) {
            long availablePost;
            long value;
            String isApprove = "";
            String isHidden = "";
            String userLogin = this.userProfile.getUserId();
            long role = this.userProfile.getUserRole();
            if (role >= 2L) {
                isHidden = "false";
            }
            Forum forum = this.getForumService().getForum(Ids[Ids.length - 3], Ids[Ids.length - 2]);
            if (role == 1L && !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)userLogin)) {
                isHidden = "false";
            }
            if ((forum.getIsModeratePost() || topic.getIsModeratePost()) && isHidden.equals("false") && !topic.getOwner().equals(userLogin)) {
                isApprove = "true";
            }
            if ((value = (availablePost = this.getForumService().getAvailablePost(Ids[Ids.length - 3], Ids[Ids.length - 2], Ids[Ids.length - 1], isApprove, isHidden, userLogin)) / maxPost) * maxPost < availablePost) {
                ++value;
            }
            this.mapNumberPagePost.put(Id, value);
            return value;
        }
        this.mapNumberPagePost.put(Id, 1L);
        return 1L;
    }

    private List<Topic> getTopicsTag() throws Exception {
        this.pageList = this.getForumService().getTopicByMyTag(this.userIdAndtagId, this.strOrderBy);
        int maxTopic = this.userProfile.getMaxTopicInPage().intValue();
        if (maxTopic <= 0) {
            maxTopic = 10;
        }
        this.pageList.setPageSize(maxTopic);
        this.maxPage = this.pageList.getAvailablePage();
        this.topics = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.topics == null) {
            this.topics = new ArrayList();
        }
        for (Topic topic : this.topics) {
            if (this.getUIFormCheckBoxInput(topic.getId()) != null) {
                this.getUIFormCheckBoxInput(topic.getId()).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(topic.getId(), topic.getId(), (Object)false));
        }
        return this.topics;
    }

    private Tag getTagById() throws Exception {
        if (this.isUpdateTag) {
            this.tag = this.getForumService().getTag(this.tagId);
            this.isUpdateTag = false;
        }
        return this.tag;
    }

    private String[] getStarNumber(Topic topic) throws Exception {
        double voteRating = topic.getVoteRating();
        return ForumUtils.getStarNumber((double)voteRating);
    }

    private Topic getTopic(String topicId) throws Exception {
        for (Topic topic : this.topics) {
            if (!topic.getId().equals(topicId)) continue;
            return topic;
        }
        return (Topic)this.getForumService().getObjectNameById(topicId, Utils.TOPIC);
    }

    private Forum getForum(String categoryId, String forumId) throws Exception {
        return this.getForumService().getForum(categoryId, forumId);
    }

    private boolean isWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            if (!path.equals(watch.getNodePath()) || !watch.isAddWatchByEmail()) continue;
            return true;
        }
        return false;
    }

    private String getEmailWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            try {
                if (!watch.getNodePath().endsWith(path)) continue;
                return watch.getEmail();
            }
            catch (Exception e) {
            }
        }
        return "";
    }

    static /* synthetic */ Topic access$000(UITopicsTag x0, String x1) throws Exception {
        return x0.getTopic(x1);
    }

    static /* synthetic */ UserProfile access$100(UITopicsTag x0) {
        return x0.userProfile;
    }

    static /* synthetic */ Forum access$200(UITopicsTag x0, String x1, String x2) throws Exception {
        return x0.getForum(x1, x2);
    }

    static /* synthetic */ UserProfile access$300(UITopicsTag x0) {
        return x0.getUserProfile();
    }

    static /* synthetic */ String access$400(UITopicsTag x0) {
        return x0.tagId;
    }

    static /* synthetic */ boolean access$502(UITopicsTag x0, boolean x1) {
        x0.isUpdateTag = x1;
        return x0.isUpdateTag;
    }

    static /* synthetic */ Tag access$600(UITopicsTag x0) throws Exception {
        return x0.getTagById();
    }

    static /* synthetic */ List access$702(UITopicsTag x0, List x1) {
        x0.listWatches = x1;
        return x0.listWatches;
    }

    static /* synthetic */ Log access$800(UITopicsTag x0) {
        return x0.log;
    }

    static /* synthetic */ String access$900(UITopicsTag x0, String x1) throws Exception {
        return x0.getEmailWatching(x1);
    }

    static /* synthetic */ Log access$1000(UITopicsTag x0) {
        return x0.log;
    }

    static /* synthetic */ String access$1100(UITopicsTag x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$1102(UITopicsTag x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

