/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIListSentPrivateMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/popup/UIListSentPrivateMessage.gtmpl", events={@EventConfig(listeners={ViewMessageActionListener.class}), @EventConfig(listeners={DeleteMessageActionListener.class}, confirm="UIPrivateMessageForm.confirm.Delete-message"), @EventConfig(listeners={ForwardMessageActionListener.class})})
public class UIListSentPrivateMessage
extends UIContainer {
    private ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    private UserProfile userProfile = null;
    private List<ForumPrivateMessage> listSend = null;
    private String userName = "";
    private boolean isRenderIterator = false;

    public UIListSentPrivateMessage() throws Exception {
        this.addChild(UIForumPageIterator.class, null, "PageListSentMessage");
    }

    private UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
        this.userName = this.userProfile.getUserId();
        return this.userProfile;
    }

    private boolean isRenderIterator() {
        return this.isRenderIterator;
    }

    private List<ForumPrivateMessage> getPrivateMessageSendByUser() throws Exception {
        JCRPageList pageList = this.forumService.getPrivateMessage(this.userName, Utils.SEND_MESSAGE);
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        forumPageIterator.updatePageList(pageList);
        if (pageList != null) {
            pageList.setPageSize(10);
            int page = forumPageIterator.getPageSelected();
            this.listSend = pageList.getPage(page);
            if (pageList.getAvailable() > 10) {
                this.isRenderIterator = true;
            }
        }
        return this.listSend;
    }

    private ForumPrivateMessage getPrivateMessage(String id) throws Exception {
        List list = this.listSend;
        for (ForumPrivateMessage forumPrivateMessage : list) {
            if (!forumPrivateMessage.getId().equals(id)) continue;
            return forumPrivateMessage;
        }
        return null;
    }

    static /* synthetic */ String access$000(UIListSentPrivateMessage x0) {
        return x0.userName;
    }

    static /* synthetic */ ForumService access$100(UIListSentPrivateMessage x0) {
        return x0.forumService;
    }

    static /* synthetic */ ForumPrivateMessage access$200(UIListSentPrivateMessage x0, String x1) throws Exception {
        return x0.getPrivateMessage(x1);
    }
}

