/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListPostHidden;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPageListPostUnApprove.gtmpl", events={@EventConfig(listeners={OpenPostLinkActionListener.class}), @EventConfig(listeners={UnHiddenActionListener.class}), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPageListPostHidden
extends UIForumKeepStickPageIterator
implements UIPopupComponent {
    private ForumService forumService;
    private String categoryId;
    private String forumId;
    private String topicId;
    private List<Post> listPost = new ArrayList();

    public UIPageListPostHidden() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.setActions(new String[]{"UnHidden", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private UserProfile getUserProfile() throws Exception {
        return ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
    }

    private String getTitleInHTMLCode(String s) {
        return ForumTransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    public void setUpdateContainer(String categoryId, String forumId, String topicId) {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
    }

    private List<Post> getPosts() throws Exception {
        this.pageList = this.forumService.getPosts(this.categoryId, this.forumId, this.topicId, "", "true", "", "");
        this.pageList.setPageSize(6);
        this.maxPage = this.pageList.getAvailablePage();
        this.listPost = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (this.listPost == null) {
            this.listPost = new ArrayList();
        }
        if (!this.listPost.isEmpty()) {
            for (Post post : this.listPost) {
                if (this.getUIFormCheckBoxInput(post.getId()) != null) {
                    this.getUIFormCheckBoxInput(post.getId()).setChecked(false);
                    continue;
                }
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(post.getId(), post.getId(), (Object)false));
            }
        }
        return this.listPost;
    }

    private Post getPost(String postId) throws Exception {
        for (Post post : this.listPost) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return this.forumService.getPost(this.categoryId, this.forumId, this.topicId, postId);
    }

    static /* synthetic */ Post access$000(UIPageListPostHidden x0, String x1) throws Exception {
        return x0.getPost(x1);
    }

    static /* synthetic */ ForumService access$100(UIPageListPostHidden x0) {
        return x0.forumService;
    }

    static /* synthetic */ List access$200(UIPageListPostHidden x0) {
        return x0.listPost;
    }
}

