/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumListSearch;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UIForumListSearch.gtmpl", events={@EventConfig(listeners={OpentContentActionListener.class}), @EventConfig(listeners={ChangeNumberItemActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIForumListSearch
extends BaseForumForm {
    private List<ForumSearch> listEvent = null;
    private boolean isShowIter = true;
    public final String SEARCH_ITERATOR = "forumSearchIterator";
    public static final String FIELD_DISPLAY_ITEM_SELECTBOX = "DisplayItem";
    public static final String ID = "id";
    public static final String GO_BACK = "Goback";
    private String pathLastVisit = "Goback" + Utils.FORUM_SERVICE;
    private JCRPageList pageList;
    private int pageSize = 10;
    private UIForumPageIterator pageIterator;
    private Map<String, String> displayItemsStorage = new HashMap();

    public UIForumListSearch() throws Exception {
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "forumSearchIterator");
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        for (int i = 10; i <= 45; i += 5) {
            ls.add(new SelectItemOption(String.valueOf(i), (Object)(ID + i)));
        }
        UIFormSelectBox displayItem = new UIFormSelectBox(FIELD_DISPLAY_ITEM_SELECTBOX, FIELD_DISPLAY_ITEM_SELECTBOX, ls);
        displayItem.setDefaultValue((Object)"id10");
        displayItem.setOnChange("ChangeNumberItem");
        this.addChild((UIComponent)displayItem);
    }

    public void setPathLastVisit(String pathLastVisit) {
        this.pathLastVisit = pathLastVisit;
    }

    public String getPathLastVisit() {
        return this.pathLastVisit;
    }

    public void setListSearchEvent(List<ForumSearch> listEvent, String pathLastVisit) throws Exception {
        this.listEvent = listEvent;
        this.setPathLastVisit(GO_BACK + pathLastVisit);
        this.pageIterator.setSelectPage(1L);
        String userId = this.getUserProfile().getUserId();
        if (this.displayItemsStorage.keySet().contains(userId)) {
            String vl = (String)this.displayItemsStorage.get(userId);
            this.pageSize = Integer.valueOf(vl.substring(2));
            this.getUIFormSelectBox(FIELD_DISPLAY_ITEM_SELECTBOX).setValue(vl);
        }
    }

    public boolean getIsShowIter() {
        return this.isShowIter;
    }

    public List<ForumSearch> getListEvent() {
        this.pageList = new ForumPageList(this.pageSize, this.listEvent.size());
        this.pageList.setPageSize(this.pageSize);
        this.pageIterator.updatePageList(this.pageList);
        this.isShowIter = true;
        if (this.pageList.getAvailablePage() <= 1) {
            this.isShowIter = false;
        }
        int pageSelect = this.pageIterator.getPageSelected();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        try {
            list.addAll(this.pageList.getPageSearch(pageSelect, this.listEvent));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private ForumSearch getForumSearch(String id) {
        for (ForumSearch forumSearch : this.listEvent) {
            if (!forumSearch.getId().equals(id)) continue;
            return forumSearch;
        }
        return null;
    }

    static /* synthetic */ ForumSearch access$000(UIForumListSearch x0, String x1) {
        return x0.getForumSearch(x1);
    }

    static /* synthetic */ int access$102(UIForumListSearch x0, int x1) {
        x0.pageSize = x1;
        return x0.pageSize;
    }

    static /* synthetic */ Map access$200(UIForumListSearch x0) {
        return x0.displayItemsStorage;
    }
}

