/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.webui.popup.UIQuickReplyForm;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIQuickReplyForm.gtmpl", events={@EventConfig(listeners={PreviewReplyActionListener.class}), @EventConfig(listeners={QuickReplyActionListener.class})})
public class UIQuickReplyForm
extends UIForm {
    private String categoryId;
    private String forumId;
    private String topicId = ForumUtils.EMPTY_STR;
    private String userName;
    private String links = ForumUtils.EMPTY_STR;
    private Topic topic;
    private boolean isModerator = false;
    public static final String FIELD_MESSAGE_TEXTAREA = "Message";

    public UIQuickReplyForm() {
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MESSAGE_TEXTAREA, FIELD_MESSAGE_TEXTAREA, null));
    }

    private String getLink() {
        return this.links;
    }

    public void setInitForm(String categoryId, String forumId, String topicId, boolean isModerator) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        this.isModerator = isModerator;
        this.userName = UserHelper.getCurrentUser();
        try {
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            this.topic = forumService.getTopic(categoryId, forumId, topicId, this.userName);
        }
        catch (Exception e) {
            this.topic = new Topic();
        }
    }

    static /* synthetic */ boolean access$000(UIQuickReplyForm x0) {
        return x0.isModerator;
    }

    static /* synthetic */ Topic access$100(UIQuickReplyForm x0) {
        return x0.topic;
    }

    static /* synthetic */ String access$200(UIQuickReplyForm x0) {
        return x0.userName;
    }

    static /* synthetic */ String access$300(UIQuickReplyForm x0) {
        return x0.topicId;
    }

    static /* synthetic */ String access$400(UIQuickReplyForm x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$500(UIQuickReplyForm x0) {
        return x0.forumId;
    }
}

