/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIFormSelectBoxForum;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UIForumLinks.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIForumLinks
extends BaseForumForm {
    public static final String FIELD_FORUMLINK_SELECTBOX = "forumLink";
    public static final String FIELD_FORUMHOMEPAGE_LABEL = "forumHomePage";
    private String path = Utils.FORUM_SERVICE;
    private List<ForumLinkData> forumLinks = null;

    private StringBuffer getStrQuery(List<String> list, String property) {
        StringBuffer strQuery = new StringBuffer();
        String AC = property.indexOf("fn") < 0 ? "@" : ForumUtils.EMPTY_STR;
        for (String string : list) {
            if (strQuery.length() == 0) {
                strQuery.append("(").append(AC).append(property).append("='").append(string).append("'");
                continue;
            }
            strQuery.append(" or ").append(AC).append(property).append("='").append(string).append("'");
        }
        if (strQuery.length() > 0) {
            strQuery.append(")");
        }
        return strQuery;
    }

    public void setUpdateForumLinks() throws Exception {
        UIFormSelectBoxForum forumLink;
        UIForumPortlet forumPortlet;
        block24: {
            forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
            try {
                this.userProfile = forumPortlet.getUserProfile();
            }
            catch (Exception e) {
                String userName = UserHelper.getCurrentUser();
                if (userName == null) break block24;
                try {
                    this.userProfile = this.getForumService().getQuickProfile(userName);
                }
                catch (Exception ex) {
                    this.userProfile = new UserProfile();
                }
            }
        }
        StringBuffer buffQueryCate = new StringBuffer();
        StringBuffer buffQueryForum = new StringBuffer();
        List listUser = UserHelper.getAllGroupAndMembershipOfUser((String)this.userProfile.getUserId());
        if (this.userProfile.getUserRole() > 0L) {
            StringBuffer mods = this.getStrQuery(listUser, "exo:moderators");
            if (mods.length() > 0) {
                buffQueryForum.append("(@").append("exo:isClosed").append("='false' or ").append(mods).append(")");
            } else {
                buffQueryForum.append("(@").append("exo:isClosed").append("='false')");
            }
            listUser.add(" ");
            buffQueryCate = this.getStrQuery(listUser, "exo:userPrivate");
        }
        List listCateIdScope = forumPortlet.getInvisibleCategories();
        List listForumIdScope = forumPortlet.getInvisibleForums();
        if (!listForumIdScope.isEmpty() && !((String)listForumIdScope.get(0)).equals(" ")) {
            if (buffQueryForum.length() > 0) {
                buffQueryForum.append(" and ").append(this.getStrQuery(listForumIdScope, "fn:name()"));
            } else {
                buffQueryForum.append(this.getStrQuery(listForumIdScope, "fn:name()"));
            }
        }
        if (!listCateIdScope.isEmpty() && !((String)listCateIdScope.get(0)).equals(" ")) {
            if (buffQueryCate.length() > 0) {
                buffQueryCate.append(" and ").append(this.getStrQuery(listCateIdScope, "fn:name()"));
            } else {
                buffQueryCate.append(this.getStrQuery(listCateIdScope, "fn:name()"));
            }
        }
        if (buffQueryForum.length() > 0) {
            buffQueryForum = new StringBuffer("[").append(buffQueryForum).append("]");
        }
        if (buffQueryCate.length() > 0) {
            buffQueryCate = new StringBuffer("[").append(buffQueryCate).append("]");
        }
        this.forumLinks = this.getForumService().getAllLink(buffQueryCate.toString(), buffQueryForum.toString());
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(this.getLabel(FIELD_FORUMHOMEPAGE_LABEL) + ForumUtils.SLASH + FIELD_FORUMHOMEPAGE_LABEL, (Object)Utils.FORUM_SERVICE));
        String space = "&nbsp; &nbsp; ";
        String type = "/categoryLink";
        for (ForumLinkData linkData : this.forumLinks) {
            if (linkData.getType().equals(Utils.FORUM)) {
                type = ForumUtils.SLASH + FIELD_FORUMLINK_SELECTBOX;
                space = "&nbsp; &nbsp; &nbsp; &nbsp; ";
            }
            if (linkData.getType().equals(Utils.CATEGORY)) {
                type = "/categoryLink";
                space = "&nbsp; &nbsp; ";
            }
            if (linkData.getType().equals(Utils.TOPIC)) continue;
            list.add(new SelectItemOption(space + linkData.getName() + type, (Object)linkData.getPath()));
        }
        if (this.getChild(UIFormSelectBoxForum.class) != null) {
            forumLink = ((UIFormSelectBoxForum)this.getChild(UIFormSelectBoxForum.class)).setOptions(list);
            if (ForumUtils.isEmpty((String)this.path)) {
                forumLink.setValue(Utils.FORUM_SERVICE);
            } else {
                forumLink.setValue(this.path.trim());
            }
        } else {
            forumLink = new UIFormSelectBoxForum(FIELD_FORUMLINK_SELECTBOX, FIELD_FORUMLINK_SELECTBOX, list);
            if (ForumUtils.isEmpty((String)this.path)) {
                forumLink.setValue(Utils.FORUM_SERVICE);
            } else {
                forumLink.setValue(this.path.trim());
            }
            this.addUIFormInput((UIFormInput)forumLink);
        }
    }

    public UIFormSelectBoxForum getUIFormSelectBoxForum(String name) {
        return (UIFormSelectBoxForum)this.findComponentById(name);
    }

    public List<ForumLinkData> getForumLinks() {
        return this.forumLinks;
    }

    public void setValueOption(String path) {
        this.path = path;
    }

    static /* synthetic */ String access$000(UIForumLinks x0) {
        return x0.path;
    }

    static /* synthetic */ void access$100(UIForumLinks x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ String access$002(UIForumLinks x0, String x1) {
        x0.path = x1;
        return x0.path;
    }

    static /* synthetic */ Log access$200(UIForumLinks x0) {
        return x0.log;
    }
}

