/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/forum/webui/UIForumActionBar.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddForumActionListener.class}), @EventConfig(listeners={ManageModeratorActionListener.class}), @EventConfig(listeners={EditProfileActionListener.class}), @EventConfig(listeners={OpenBookMarkActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={ModerationActionListener.class}), @EventConfig(listeners={ImportCategoryActionListener.class}), @EventConfig(listeners={ExportCategoryActionListener.class}), @EventConfig(listeners={SortSettingActionListener.class}), @EventConfig(listeners={CensorKeywordActionListener.class}), @EventConfig(listeners={NotificationActionListener.class}), @EventConfig(listeners={BBCodeManagerActionListener.class}), @EventConfig(listeners={AutoPruneActionListener.class}), @EventConfig(listeners={TopicTypeManagerActionListener.class}), @EventConfig(listeners={OpenIPBanActionListener.class})})
public class UIForumActionBar
extends UIContainer {
    private UserProfile userProfile;
    private ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    private boolean isSpace = false;
    private static final String RELOAD = "RELOAD".intern();

    private UserProfile getUserProfile() {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getParent();
        this.userProfile = forumPortlet.getUserProfile();
        this.isSpace = !ForumUtils.isEmpty((String)forumPortlet.getForumIdOfSpace());
        return this.userProfile;
    }

    protected boolean isSpace() {
        return this.isSpace;
    }

    protected String[] getActionMenu() {
        String[] stringArray;
        if (ForumUtils.enableIPLogging()) {
            String[] stringArray2 = new String[9];
            stringArray2[0] = "SortSetting";
            stringArray2[1] = "CensorKeyword";
            stringArray2[2] = "Notification";
            stringArray2[3] = "BBCodeManager";
            stringArray2[4] = "AutoPrune";
            stringArray2[5] = "TopicTypeManager";
            stringArray2[6] = "OpenIPBan";
            stringArray2[7] = "ExportCategory";
            stringArray = stringArray2;
            stringArray2[8] = "ImportCategory";
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = "SortSetting";
            stringArray3[1] = "CensorKeyword";
            stringArray3[2] = "Notification";
            stringArray3[3] = "BBCodeManager";
            stringArray3[4] = "AutoPrune";
            stringArray3[5] = "TopicTypeManager";
            stringArray3[6] = "ExportCategory";
            stringArray = stringArray3;
            stringArray3[7] = "ImportCategory";
        }
        return stringArray;
    }

    protected int getTotalJobWattingForModerator() throws Exception {
        return this.forumService.getJobWattingForModeratorByUser(this.userProfile.getUserId());
    }

    protected long getNewMessage() {
        try {
            String username = this.userProfile.getUserId();
            return this.forumService.getNewPrivateMessage(username);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getCometdContextName() {
        return ((UIForumPortlet)this.getParent()).getCometdContextName();
    }

    public String getUserToken() throws Exception {
        return ((UIForumPortlet)this.getParent()).getUserToken();
    }

    static /* synthetic */ UserProfile access$000(UIForumActionBar x0) {
        return x0.userProfile;
    }

    static /* synthetic */ String access$100() {
        return RELOAD;
    }

    static /* synthetic */ UserProfile access$200(UIForumActionBar x0) {
        return x0.getUserProfile();
    }

    static /* synthetic */ ForumService access$300(UIForumActionBar x0) {
        return x0.forumService;
    }
}

