/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.io.InputStream;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.UIForumQuickReplyPortlet;
import org.exoplatform.forum.rendering.RenderHelper;
import org.exoplatform.forum.rendering.RenderingException;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIViewPost;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewPost.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ApproveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeletePostActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenTopicLinkActionListener.class}), @EventConfig(listeners={DownloadAttachActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewPost
extends UIForm
implements UIPopupComponent {
    private Post post;
    private boolean isViewUserInfo = true;
    private ForumService forumService;
    private UserProfile userProfile;
    RenderHelper renderHelper = new RenderHelper();
    private static Log log = ExoLogger.getLogger(UIViewPost.class);

    public UIViewPost() {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    }

    public void setActionForm(String[] actions) {
        this.setActions(actions);
    }

    protected UserProfile getUserProfile() {
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        return this.userProfile;
    }

    public String renderPost(Post post) throws RenderingException {
        return this.renderHelper.renderPost(post);
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = ForumUtils.EMPTY_STR;
        try {
            url = CommonUtils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            log.warn((Object)(imagePath + " is not exist: " + e.getMessage()));
        }
        return url;
    }

    protected String getFileSource(ForumAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return ForumSessionUtils.getFileSource((InputStream)input, (String)fileName, (DownloadService)dservice);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void setPostView(Post post) throws Exception {
        this.post = post;
    }

    protected Post getPostView() throws Exception {
        return this.post;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setViewUserInfo(boolean isView) {
        this.isViewUserInfo = isView;
    }

    public boolean getIsViewUserInfo() {
        return this.isViewUserInfo;
    }

    private void closeAction(WebuiRequestContext context) throws Exception {
        UIPopupContainer popupContainer = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
        if (popupContainer != null) {
            UIPopupAction popupAction = this.getParent().getId().equals(popupContainer.getId()) ? (UIPopupAction)popupContainer.getAncestorOfType(UIPopupAction.class) : (UIPopupAction)popupContainer.getChild(UIPopupAction.class);
            popupAction.deActivate();
            context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
        } else {
            try {
                UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
                forumPortlet.cancelAction();
            }
            catch (Exception e) {
                UIForumQuickReplyPortlet forumPortlet = (UIForumQuickReplyPortlet)this.getAncestorOfType(UIForumQuickReplyPortlet.class);
                forumPortlet.cancelAction();
            }
        }
    }

    static /* synthetic */ Post access$000(UIViewPost x0) {
        return x0.post;
    }

    static /* synthetic */ ForumService access$100(UIViewPost x0) {
        return x0.forumService;
    }

    static /* synthetic */ Log access$200() {
        return log;
    }

    static /* synthetic */ void access$300(UIViewPost x0, WebuiRequestContext x1) throws Exception {
        x0.closeAction(x1);
    }
}

