/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UISliderControl;
import org.exoplatform.forum.webui.popup.UIGroupSelector;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.ks.common.webui.UIUserSelect;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BaseForumForm
extends BaseUIForm {
    private ForumService forumService;
    public UserProfile userProfile = null;
    public List<Watch> listWatches = new ArrayList();

    protected ForumService getForumService() {
        if (this.forumService == null) {
            this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        }
        return this.forumService;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).updateCurrentUserProfile();
        if (this.getTemplate() != null) {
            super.processRender(context);
            return;
        }
        Writer writer = context.getWriter();
        writer.append("<div class='UIForm ").append(this.getId()).append("'>");
        this.begin();
        this.renderChildren(context);
        this.end();
        writer.append("</div>");
    }

    protected void setForumService(ForumService forumService) {
        this.forumService = forumService;
    }

    public UISliderControl getUISliderControl(String name) {
        return (UISliderControl)this.findComponentById(name);
    }

    public UserProfile getUserProfile() throws Exception {
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        return this.userProfile;
    }

    protected void setListWatches() throws Exception {
        this.listWatches = this.getForumService().getWatchByUser(this.getUserProfile().getUserId());
    }

    protected boolean isWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            if (!path.equals(watch.getNodePath()) || !watch.isAddWatchByEmail()) continue;
            return true;
        }
        return false;
    }

    protected String getEmailWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            try {
                if (!watch.getNodePath().endsWith(path)) continue;
                return watch.getEmail();
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to check email watching.");
            }
        }
        return ForumUtils.EMPTY_STR;
    }

    protected String getScreenName(String userName) throws Exception {
        return this.getForumService().getScreenName(userName);
    }

    protected String getShortScreenName(String screenName) throws Exception {
        if (screenName != null && screenName.length() > 17 && !screenName.trim().contains(" ")) {
            boolean isDelted = false;
            if (screenName.indexOf("<s>") >= 0) {
                screenName = screenName.replaceAll("<s>", ForumUtils.EMPTY_STR).replaceAll("</s>", ForumUtils.EMPTY_STR);
                isDelted = true;
            }
            screenName = "<span title=\"" + screenName + "\">" + (isDelted ? "<s>" : ForumUtils.EMPTY_STR) + ForumUtils.getSubString((String)screenName, (int)15) + (isDelted ? "</s></span>" : "</span>");
        }
        return screenName;
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, String popupId, int width, int height) throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        return (T)this.openPopup((UIContainer)forumPortlet, componentType, popupId, width, height);
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, int width, int height) throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        return (T)this.openPopup((UIContainer)forumPortlet, componentType, width, height);
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, int width) throws Exception {
        return (T)this.openPopup(componentType, width, 0);
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, String popupId, int width) throws Exception {
        return (T)this.openPopup(componentType, popupId, width, 0);
    }

    protected boolean addWatch(String path, UserProfile userProfile) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            values.add(userProfile.getEmail());
            this.getForumService().addWatch(1, path, values, userProfile.getUserId());
            this.setListWatches();
            this.info("UIAddWatchingForm.msg.successfully");
            return true;
        }
        catch (Exception e) {
            this.warning("UIAddWatchingForm.msg.fall");
            return false;
        }
    }

    protected boolean unWatch(String path, UserProfile userProfile) {
        try {
            this.getForumService().removeWatch(1, path, userProfile.getUserId() + ForumUtils.SLASH + this.getEmailWatching(path));
            this.setListWatches();
            this.info("UIAddWatchingForm.msg.UnWatchSuccessfully");
            return true;
        }
        catch (Exception e) {
            this.warning("UIAddWatchingForm.msg.UnWatchfall");
            this.log.debug((Object)"Failed to add watch.");
            return false;
        }
    }

    protected static void closePopupWindow(UIPopupWindow popupWindow) {
        popupWindow.setUIComponent(null);
        popupWindow.setShow(false);
        popupWindow.setRendered(false);
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        context.addUIComponentToUpdateByAjax(popupWindow.getParent());
    }

    protected void showUIUserSelect(UIPopupContainer uiPopupContainer, String popupWinDowId, String id) throws Exception {
        UIPopupWindow uiPopupWindow;
        UIGroupSelector uiGroupSelector = (UIGroupSelector)uiPopupContainer.findFirstComponentOfType(UIGroupSelector.class);
        if (uiGroupSelector != null) {
            UIPopupWindow popupWindow = (UIPopupWindow)uiGroupSelector.getAncestorOfType(UIPopupWindow.class);
            BaseForumForm.closePopupWindow((UIPopupWindow)popupWindow);
        }
        if ((uiPopupWindow = (UIPopupWindow)uiPopupContainer.getChildById(popupWinDowId)) == null) {
            uiPopupWindow = (UIPopupWindow)uiPopupContainer.addChild(UIPopupWindow.class, popupWinDowId, popupWinDowId);
        }
        UIUserSelect uiUserSelector = (UIUserSelect)uiPopupContainer.createUIComponent(UIUserSelect.class, null, "UIUserSelector");
        uiUserSelector.setShowSearch(true);
        uiUserSelector.setShowSearchUser(true);
        uiUserSelector.setShowSearchGroup(false);
        uiUserSelector.setPermisionType(id);
        uiPopupWindow.setUIComponent((UIComponent)uiUserSelector);
        uiPopupWindow.setShow(true);
        uiPopupWindow.setWindowSize(740, 400);
        uiPopupWindow.setRendered(true);
        uiPopupContainer.setRendered(true);
    }
}

