/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIShowBookMarkForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIShowBookMarkForm.gtmpl", events={@EventConfig(listeners={OpenLinkActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteLinkActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIShowBookMarkForm
extends BaseForumForm
implements UIPopupComponent {
    public final String BOOKMARK_ITERATOR = "BookmarkPageIterator";
    private JCRPageList pageList;
    UIForumPageIterator pageIterator;
    private List<String> bookMarks = new ArrayList();

    public UIShowBookMarkForm() throws Exception {
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "BookmarkPageIterator");
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private void updateBookMark() {
        try {
            this.bookMarks = this.getForumService().getBookmarks(this.getUserProfile().getUserId());
        }
        catch (Exception e) {
            this.log.error((Object)"Getting book mark fail: ", (Throwable)e);
        }
    }

    private List<String> getBookMark() throws Exception {
        this.updateBookMark();
        this.pageList = new ForumPageList(6, this.bookMarks.size());
        this.pageList.setPageSize(6);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pageList.getPageList((long)this.pageIterator.getPageSelected(), this.bookMarks));
        this.pageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        try {
            if (this.pageList.getAvailablePage() <= 1) {
                this.pageIterator.setRendered(false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("\nCould not render a UIComponent: " + e.getMessage() + "\n" + e.getCause()));
        }
        return list;
    }

    private String getBookMarkId(String id) throws Exception {
        for (String str : this.bookMarks) {
            if (str.indexOf(id) < 0) continue;
            return str;
        }
        return ForumUtils.EMPTY_STR;
    }

    private String getType(String id) {
        return id.indexOf(Utils.FORUM_SERVICE) >= 0 ? Utils.FORUM_SERVICE : (id.indexOf(Utils.CATEGORY) >= 0 ? ForumUtils.CATEGORY : (id.indexOf(Utils.FORUM) >= 0 ? ForumUtils.FORUM : (id.indexOf(Utils.TOPIC) >= 0 ? ForumUtils.TOPIC : ForumUtils.EMPTY_STR)));
    }

    static /* synthetic */ void access$000(UIShowBookMarkForm x0) {
        x0.updateBookMark();
    }

    static /* synthetic */ List access$100(UIShowBookMarkForm x0) {
        return x0.bookMarks;
    }

    static /* synthetic */ ForumService access$200(UIShowBookMarkForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ void access$300(UIShowBookMarkForm x0, String x1) {
        x0.warning(x1);
    }
}

