/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.TimeConvertUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UICategoryInfo;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UICategoryInfo.gtmpl", events={@EventConfig(listeners={CreatedLinkActionListener.class})})
public class UICategoryInfo
extends UIContainer {
    private ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    private UserProfile userProfile;

    private List<String> getUserOnline() throws Exception {
        return this.forumService.getOnlineUsers();
    }

    private String getScreenName(String userName) throws Exception {
        return this.forumService.getScreenName(userName);
    }

    private UserProfile getUserProfile() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        return this.userProfile;
    }

    private String getActionViewInfoUser(String linkType, String userName) {
        return ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getPortletLink(linkType, userName);
    }

    private String getMostUsersOnline(String s, String at) throws Exception {
        if (ForumUtils.isEmpty((String)s)) {
            return ForumUtils.EMPTY_STR;
        }
        try {
            String[] strs = s.split(ForumUtils.COMMA);
            long l = Long.parseLong(strs[1].replace("at", ForumUtils.EMPTY_STR).trim());
            Calendar calendar = CommonUtils.getGreenwichMeanTime();
            double timeZone = this.userProfile.getTimeZone();
            if (this.userProfile.getUserId().equals("user_gest_uoom")) {
                timeZone = 0.0;
            }
            long zone = (long)(timeZone * 3600000.0);
            calendar.setTimeInMillis(l - zone);
            StringBuilder builder = new StringBuilder();
            if (ForumUtils.isEmpty((String)at)) {
                at = "at";
            }
            builder.append(strs[0]).append(", ").append(at).append(" ");
            builder.append(TimeConvertUtils.getFormatDate((String)(this.userProfile.getLongDateFormat() + ", " + this.userProfile.getTimeFormat()), (Date)calendar.getTime()));
            if (this.userProfile.getUserId().equals("user_gest_uoom")) {
                if (timeZone >= 0.0) {
                    builder.append(" GMT+").append(String.valueOf(timeZone).replace(".0", ForumUtils.EMPTY_STR));
                } else {
                    builder.append(" GMT").append(String.valueOf(timeZone).replace(".0", ForumUtils.EMPTY_STR));
                }
            }
            s = builder.toString();
        }
        catch (Exception e) {
            s = s.replace("at", at);
        }
        return s;
    }

    public ForumStatistic getForumStatistic() throws Exception {
        return this.forumService.getForumStatistic();
    }
}

