/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.rendering.RenderHelper;
import org.exoplatform.forum.rendering.RenderingException;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIModerationForum;
import org.exoplatform.forum.webui.popup.UIViewTopic;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.TransformHTML;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.ks.common.webui.UIPopupContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewTopic.gtmpl", events={@EventConfig(listeners={ApproveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteTopicActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewTopic
extends BaseForumForm
implements UIPopupComponent {
    public static final String SIGNATURE = "SignatureTypeID";
    private Topic topic;
    private JCRPageList pageList;
    private int pageSelect;
    private Map<String, UserProfile> mapUserProfile = new HashMap();
    RenderHelper renderHelper = new RenderHelper();
    private static Log log = ExoLogger.getLogger(UIViewTopic.class);

    public UIViewTopic() throws Exception {
        this.addChild(UIForumPageIterator.class, null, "ViewTopicPageIterator");
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public void setActionForm(String[] actions) {
        this.setActions(actions);
    }

    public String renderPost(Post post) throws RenderingException {
        if (SIGNATURE.equals(post.getId())) {
            post.setMessage(TransformHTML.enCodeViewSignature((String)post.getMessage()));
        }
        return this.renderHelper.renderPost(post);
    }

    private void initPage() throws Exception {
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        String userLogin = this.userProfile.getUserId();
        Topic topic = this.topic;
        String[] id = topic.getPath().split(ForumUtils.SLASH);
        int l = id.length;
        this.pageList = this.getForumService().getPosts(id[l - 3], id[l - 2], topic.getId(), ForumUtils.EMPTY_STR, ForumUtils.EMPTY_STR, ForumUtils.EMPTY_STR, userLogin);
        long maxPost = this.userProfile.getMaxPostInPage();
        if (maxPost <= 0L) {
            maxPost = 10L;
        }
        this.pageList.setPageSize((int)maxPost);
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        forumPageIterator.updatePageList(this.pageList);
    }

    private void updateUserProfiles(List<Post> posts) throws Exception {
        ArrayList<String> userNames = new ArrayList<String>();
        for (Post post : posts) {
            if (userNames.contains(post.getOwner())) continue;
            userNames.add(post.getOwner());
        }
        if (userNames.size() > 0) {
            try {
                List profiles = this.getForumService().getQuickProfiles(userNames);
                for (UserProfile profile : profiles) {
                    this.mapUserProfile.put(profile.getUserId(), profile);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed load user info: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private List<Post> getPostPageList() throws Exception {
        ArrayList<Post> posts;
        if (this.pageList == null) {
            return null;
        }
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageSelect = forumPageIterator.getPageSelected();
        int availablePage = this.pageList.getAvailablePage();
        if (this.pageSelect > availablePage) {
            this.pageSelect = availablePage;
            forumPageIterator.setSelectPage((long)availablePage);
        }
        if ((posts = this.pageList.getPage(this.pageSelect)) == null) {
            posts = new ArrayList<Post>();
        }
        this.updateUserProfiles((List)posts);
        return posts;
    }

    private boolean getIsRenderIter() {
        long availablePage = this.pageList.getAvailablePage();
        return availablePage > 1L;
    }

    private UserProfile getUserInfo(String userName) throws Exception {
        UserProfile profile = (UserProfile)this.mapUserProfile.get(userName);
        if (profile == null) {
            profile = new UserProfile();
            profile.setUserId(userName);
            profile.setUserTitle("User");
            profile.setUserRole(2L);
        }
        return profile;
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = ForumUtils.EMPTY_STR;
        try {
            url = CommonUtils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            log.warn((Object)(imagePath + " must exist: " + e.getCause()));
        }
        return url;
    }

    private String getFileSource(ForumAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return ForumSessionUtils.getFileSource((InputStream)input, (String)fileName, (DownloadService)dservice);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private String getAvatarUrl(String userId) throws Exception {
        return ForumSessionUtils.getUserAvatarURL((String)userId, (ForumService)this.getForumService());
    }

    private boolean isOnline(String userId) throws Exception {
        return this.getForumService().isOnline(userId);
    }

    public static void closePopup(WebuiRequestContext context, UIForm uiForm) throws Exception {
        UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
        if (popupContainer != null) {
            UIPopupAction popupAction = (UIPopupAction)popupContainer.getChild(UIPopupAction.class);
            popupAction.deActivate();
            context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
            UIModerationForum moderationForum = (UIModerationForum)popupContainer.getChild(UIModerationForum.class);
            if (moderationForum != null) {
                moderationForum.setReloadPortlet(true);
                context.addUIComponentToUpdateByAjax((UIComponent)moderationForum);
            }
        } else {
            UIForumPortlet forumPortlet = (UIForumPortlet)uiForm.getAncestorOfType(UIForumPortlet.class);
            forumPortlet.cancelAction();
        }
    }

    static /* synthetic */ Topic access$000(UIViewTopic x0) {
        return x0.topic;
    }

    static /* synthetic */ ForumService access$100(UIViewTopic x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$200(UIViewTopic x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Log access$300() {
        return log;
    }

    static /* synthetic */ ForumService access$400(UIViewTopic x0) {
        return x0.getForumService();
    }
}

