/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.Date;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumCheckBoxInput;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.forum.webui.UITopicDetailContainer;
import org.exoplatform.forum.webui.UITopicPoll;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicPoll.gtmpl", events={@EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={EditPollActionListener.class}), @EventConfig(listeners={RemovePollActionListener.class}, confirm="UITopicPoll.msg.confirm-RemovePoll"), @EventConfig(listeners={ClosedPollActionListener.class}), @EventConfig(listeners={VoteAgainPollActionListener.class})})
public class UITopicPoll
extends BaseForumForm {
    private Poll poll_;
    private String categoryId;
    private String forumId;
    private String topicId;
    private boolean isAgainVote = false;
    private boolean isEditPoll = false;
    private boolean canViewEditMenu = false;
    private boolean userIsBanned = false;
    private Forum forum;
    private PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
    private String pollId;

    public UserProfile getUserProfile() throws Exception {
        this.userProfile = new UserProfile();
        try {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
        catch (Exception e) {
            try {
                this.userProfile = this.getForumService().getDefaultUserProfile(UserHelper.getCurrentUser(), ForumUtils.EMPTY_STR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.userProfile;
    }

    public void setForum(Forum forum) {
        if (forum == null) {
            try {
                this.forum = this.getForumService().getForum(this.categoryId, this.forumId);
            }
            catch (Exception exception) {}
        } else {
            this.forum = forum;
        }
    }

    public void updateFormPoll(String categoryId, String forumId, String topicId) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        this.isEditPoll = true;
        this.isAgainVote = false;
    }

    private void init() throws Exception {
        ArrayList children = new ArrayList(this.getChildren());
        for (UIComponent child : children) {
            if (!(child instanceof UIFormRadioBoxInput) && !(child instanceof UIForumCheckBoxInput)) continue;
            this.removeChild(child.getClass());
        }
        if (this.poll_ != null) {
            if (!this.poll_.getIsMultiCheck()) {
                ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
                for (String s : this.poll_.getOption()) {
                    options.add(new SelectItemOption(s, (Object)s));
                }
                UIFormRadioBoxInput input = new UIFormRadioBoxInput("vote", "vote", options);
                input.setAlign(1);
                this.addUIFormInput((UIFormInput)input);
            } else {
                for (String s : this.poll_.getOption()) {
                    this.addUIFormInput((UIFormInput)new UIForumCheckBoxInput(s, s, Boolean.valueOf(false)));
                }
            }
        }
    }

    private Poll getPoll() throws Exception {
        if (!ForumUtils.isEmpty((String)this.categoryId)) {
            this.canViewEditMenu = this.userProfile.getUserRole() == 0L || ForumServiceUtils.hasPermission((String[])this.forum.getModerators(), (String)this.userProfile.getUserId());
            this.pollId = this.forum.getPath() + ForumUtils.SLASH + this.topicId + ForumUtils.SLASH + this.topicId.replace(Utils.TOPIC, Utils.POLL);
            try {
                this.poll_ = this.pollService.getPoll(this.pollId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init();
            return this.poll_;
        }
        return null;
    }

    protected boolean getIsEditPoll() {
        return this.isEditPoll;
    }

    public void setEditPoll(boolean isEditPoll) {
        this.isEditPoll = isEditPoll;
    }

    protected boolean getCanViewEditMenu() {
        return this.canViewEditMenu;
    }

    protected boolean isGuestPermission() throws Exception {
        String[] userVotes;
        Date today;
        if (this.poll_.getIsClosed()) {
            return true;
        }
        String userVote = this.userProfile.getUserId();
        this.userIsBanned = this.userProfile.getIsBanned();
        if (this.userIsBanned || this.userProfile.getUserRole() > 2L) {
            return true;
        }
        if (ForumUtils.isEmpty((String)userVote)) {
            return true;
        }
        if (this.poll_.getTimeOut() > 0L && (today = new Date()).getTime() - this.poll_.getCreatedDate().getTime() >= this.poll_.getTimeOut() * 86400000L) {
            return true;
        }
        if (this.isAgainVote) {
            return false;
        }
        for (String string : userVotes = this.poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(org.exoplatform.poll.service.Utils.COLON))).equalsIgnoreCase(userVote)) continue;
            return true;
        }
        return false;
    }

    protected String[] getInfoVote() throws Exception {
        Poll poll = this.poll_;
        String[] voteNumber = poll.getVote();
        String[] userVotes = poll.getUserVote();
        long size = 0L;
        long temp = 1L;
        if (!poll.getIsMultiCheck()) {
            size = userVotes.length;
        } else {
            for (int i = 0; i < userVotes.length; ++i) {
                size += (long)(userVotes[i].split(org.exoplatform.poll.service.Utils.COLON).length - 1);
            }
        }
        temp = size;
        if (size == 0L) {
            size = 1L;
        }
        int l = voteNumber.length;
        String[] infoVote = new String[l + 1];
        for (int j = 0; j < l; ++j) {
            String string = voteNumber[j];
            double tmp = Double.parseDouble(string);
            double k = tmp * (double)size / 100.0;
            int t = (int)Math.round(k);
            string = ForumUtils.EMPTY_STR + (double)t * 100.0 / (double)size;
            infoVote[j] = string + org.exoplatform.poll.service.Utils.COLON + t;
        }
        infoVote[l] = ForumUtils.EMPTY_STR + temp;
        if (poll.getIsMultiCheck()) {
            infoVote[l] = String.valueOf(userVotes.length);
        }
        return infoVote;
    }

    protected void reloadTopicDetail() {
        UITopicDetailContainer topicDetailContainer = (UITopicDetailContainer)this.getParent();
        ((UITopicDetail)topicDetailContainer.getChild(UITopicDetail.class)).setIsEditTopic(true);
    }

    static /* synthetic */ String access$000(UITopicPoll x0) {
        return x0.pollId;
    }

    static /* synthetic */ Poll access$102(UITopicPoll x0, Poll x1) {
        x0.poll_ = x1;
        return x0.poll_;
    }

    static /* synthetic */ PollService access$200(UITopicPoll x0) {
        return x0.pollService;
    }

    static /* synthetic */ Poll access$100(UITopicPoll x0) {
        return x0.poll_;
    }

    static /* synthetic */ void access$300(UITopicPoll x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$400(UITopicPoll x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ boolean access$502(UITopicPoll x0, boolean x1) {
        x0.isAgainVote = x1;
        return x0.isAgainVote;
    }

    static /* synthetic */ String access$600(UITopicPoll x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$700(UITopicPoll x0) {
        return x0.forumId;
    }

    static /* synthetic */ String access$800(UITopicPoll x0) {
        return x0.topicId;
    }

    static /* synthetic */ boolean access$902(UITopicPoll x0, boolean x1) {
        x0.isEditPoll = x1;
        return x0.isEditPoll;
    }

    static /* synthetic */ Poll access$1000(UITopicPoll x0) throws Exception {
        return x0.getPoll();
    }

    static /* synthetic */ void access$1100(UITopicPoll x0) throws Exception {
        x0.init();
    }
}

