/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.webui;

import java.util.ArrayList;
import javax.portlet.PortletMode;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.poll.Utils;
import org.exoplatform.poll.webui.UIPoll;
import org.exoplatform.poll.webui.UIPollManagement;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/poll/webui/UIPollPortlet.gtmpl")
public class UIPollPortlet
extends UIPortletApplication {
    private boolean isAdmin = false;
    private String userId = "";
    private PortletMode portletMode;

    public UIPollPortlet() throws Exception {
        ((UIPoll)this.addChild(UIPoll.class, null, null)).setRendered(false);
        ((UIPollManagement)this.addChild(UIPollManagement.class, null, null)).setRendered(true);
        this.addChild(UIPopupAction.class, null, "UIPollPopupAction");
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        this.portletMode = portletReqContext.getApplicationMode();
        if (this.portletMode == PortletMode.VIEW) {
            UIPoll uipoll = (UIPoll)((UIPoll)this.getChild(UIPoll.class)).setRendered(true);
            this.hasGroupAdminOfGatein();
            uipoll.setPollId();
            ((UIPollManagement)this.getChild(UIPollManagement.class)).setRendered(false);
        } else if (this.portletMode == PortletMode.EDIT) {
            ((UIPoll)this.getChild(UIPoll.class)).setRendered(false);
            ((UIPollManagement)((UIPollManagement)this.getChild(UIPollManagement.class)).setRendered(true)).updateGrid();
        }
        super.processRender(app, context);
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getUserId() {
        return this.userId;
    }

    private void hasGroupAdminOfGatein() {
        this.isAdmin = false;
        try {
            UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
            ArrayList<String> list = new ArrayList<String>();
            Identity identity = ConversationState.getCurrent().getIdentity();
            this.userId = identity.getUserId();
            if (Utils.isEmpty((String)this.userId) || IdentityConstants.ANONIM.equals(this.userId)) {
                this.userId = UserHelper.getCurrentUser();
                if (!Utils.isEmpty((String)this.userId)) {
                    list.add(this.userId);
                }
            } else {
                list.addAll(identity.getGroups());
            }
            for (String str : list) {
                if (!str.equals(userACL.getSuperUser()) && !str.equals(userACL.getAdminGroups())) continue;
                this.isAdmin = true;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to check permision for user by component UserACL", (Throwable)e);
        }
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }
}

