/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.htmlcleaner.BrowserCompactXmlSerializer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CompactXmlSerializer;
import org.htmlcleaner.ConfigFileTagProvider;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XPatherException;

public class CommandLine {
    private static String getArgValue(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (!string3.toLowerCase().startsWith(string.toLowerCase())) continue;
            return string4;
        }
        return "";
    }

    private static boolean toBoolean(String string) {
        return string != null && ("on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string));
    }

    public static void main(String[] stringArray) throws IOException, XPatherException {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        String string3 = CommandLine.getArgValue(stringArray, "src");
        if ("".equals(string3)) {
            System.err.println("Usage: java -jar htmlcleanerXX.jar src = <url | file> [incharset = <charset>] [dest = <file>] [outcharset = <charset>] [taginfofile=<file>] [options...]");
            System.err.println("");
            System.err.println("where options include:");
            System.err.println("    outputtype=simple* | compact | browser-compact | pretty");
            System.err.println("    advancedxmlescape=true* | false");
            System.err.println("    usecdata=true* | false");
            System.err.println("    specialentities=true* | false");
            System.err.println("    unicodechars=true* | false");
            System.err.println("    omitunknowntags=true | false*");
            System.err.println("    treatunknowntagsascontent=true | false*");
            System.err.println("    omitdeprtags=true | false*");
            System.err.println("    treatdeprtagsascontent=true | false*");
            System.err.println("    omitcomments=true | false*");
            System.err.println("    omitxmldecl=true | false*");
            System.err.println("    omitdoctypedecl=true* | false");
            System.err.println("    omithtmlenvelope=true | false*");
            System.err.println("    useemptyelementtags=true* | false");
            System.err.println("    allowmultiwordattributes=true* | false");
            System.err.println("    allowhtmlinsideattributes=true | false*");
            System.err.println("    ignoreqe=true | false*");
            System.err.println("    namespacesaware=true* | false");
            System.err.println("    hyphenreplacement=<string value> [=]");
            System.err.println("    prunetags=<string value> []");
            System.err.println("    booleanatts=self* | empty | true");
            System.err.println("    nodebyxpath=<xpath expression>");
            System.err.println("    t:<sourcetagX>[=<desttag>[,<preserveatts>]]");
            System.err.println("    t:<sourcetagX>.<destattrY>[=<template>]");
            System.exit(1);
        }
        if ("".equals(string2 = CommandLine.getArgValue(stringArray, "incharset"))) {
            string2 = HtmlCleaner.DEFAULT_CHARSET;
        }
        if ("".equals(string = CommandLine.getArgValue(stringArray, "outcharset"))) {
            string = HtmlCleaner.DEFAULT_CHARSET;
        }
        String string4 = CommandLine.getArgValue(stringArray, "dest");
        String string5 = CommandLine.getArgValue(stringArray, "outputtype");
        String string6 = CommandLine.getArgValue(stringArray, "advancedxmlescape");
        String string7 = CommandLine.getArgValue(stringArray, "usecdata");
        String string8 = CommandLine.getArgValue(stringArray, "specialentities");
        String string9 = CommandLine.getArgValue(stringArray, "unicodechars");
        String string10 = CommandLine.getArgValue(stringArray, "omitunknowntags");
        String string11 = CommandLine.getArgValue(stringArray, "treatunknowntagsascontent");
        String string12 = CommandLine.getArgValue(stringArray, "omitdeprtags");
        String string13 = CommandLine.getArgValue(stringArray, "treatdeprtagsascontent");
        String string14 = CommandLine.getArgValue(stringArray, "omitcomments");
        String string15 = CommandLine.getArgValue(stringArray, "omitxmldecl");
        String string16 = CommandLine.getArgValue(stringArray, "omitdoctypedecl");
        String string17 = CommandLine.getArgValue(stringArray, "omithtmlenvelope");
        String string18 = CommandLine.getArgValue(stringArray, "useemptyelementtags");
        String string19 = CommandLine.getArgValue(stringArray, "allowmultiwordattributes");
        String string20 = CommandLine.getArgValue(stringArray, "allowhtmlinsideattributes");
        String string21 = CommandLine.getArgValue(stringArray, "ignoreqe");
        String string22 = CommandLine.getArgValue(stringArray, "namespacesaware");
        String string23 = CommandLine.getArgValue(stringArray, "hyphenreplacement");
        String string24 = CommandLine.getArgValue(stringArray, "prunetags");
        String string25 = CommandLine.getArgValue(stringArray, "booleanatts");
        String string26 = CommandLine.getArgValue(stringArray, "nodebyxpath");
        String string27 = CommandLine.getArgValue(stringArray, "taginfofile");
        HtmlCleaner htmlCleaner = !"".equals(string27) ? new HtmlCleaner(new ConfigFileTagProvider(new File(string27))) : new HtmlCleaner();
        CleanerProperties cleanerProperties = htmlCleaner.getProperties();
        if (!"".equals(string10)) {
            cleanerProperties.setOmitUnknownTags(CommandLine.toBoolean(string10));
        }
        if (!"".equals(string11)) {
            cleanerProperties.setTreatUnknownTagsAsContent(CommandLine.toBoolean(string11));
        }
        if (!"".equals(string12)) {
            cleanerProperties.setOmitDeprecatedTags(CommandLine.toBoolean(string12));
        }
        if (!"".equals(string13)) {
            cleanerProperties.setTreatDeprecatedTagsAsContent(CommandLine.toBoolean(string13));
        }
        if (!"".equals(string6)) {
            cleanerProperties.setAdvancedXmlEscape(CommandLine.toBoolean(string6));
        }
        if (!"".equals(string7)) {
            cleanerProperties.setUseCdataForScriptAndStyle(CommandLine.toBoolean(string7));
        }
        if (!"".equals(string8)) {
            cleanerProperties.setTranslateSpecialEntities(CommandLine.toBoolean(string8));
        }
        if (!"".equals(string9)) {
            cleanerProperties.setRecognizeUnicodeChars(CommandLine.toBoolean(string9));
        }
        if (!"".equals(string14)) {
            cleanerProperties.setOmitComments(CommandLine.toBoolean(string14));
        }
        if (!"".equals(string15)) {
            cleanerProperties.setOmitXmlDeclaration(CommandLine.toBoolean(string15));
        }
        if (!"".equals(string16)) {
            cleanerProperties.setOmitDoctypeDeclaration(CommandLine.toBoolean(string16));
        }
        if (!"".equals(string17)) {
            cleanerProperties.setOmitHtmlEnvelope(CommandLine.toBoolean(string17));
        }
        if (!"".equals(string18)) {
            cleanerProperties.setUseEmptyElementTags(CommandLine.toBoolean(string18));
        }
        if (!"".equals(string19)) {
            cleanerProperties.setAllowMultiWordAttributes(CommandLine.toBoolean(string19));
        }
        if (!"".equals(string20)) {
            cleanerProperties.setAllowHtmlInsideAttributes(CommandLine.toBoolean(string20));
        }
        if (!"".equals(string21)) {
            cleanerProperties.setIgnoreQuestAndExclam(CommandLine.toBoolean(string21));
        }
        if (!"".equals(string22)) {
            cleanerProperties.setNamespacesAware(CommandLine.toBoolean(string22));
        }
        if (!"".equals(string23)) {
            cleanerProperties.setHyphenReplacementInComment(string23);
        }
        if (!"".equals(string24)) {
            cleanerProperties.setPruneTags(string24);
        }
        if (!"".equals(string25)) {
            cleanerProperties.setBooleanAttributeValues(string25);
        }
        TreeMap<Object, Object[]> treeMap = new TreeMap<Object, Object[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = stringArray[i];
            if (!((String)object3).startsWith("t:") || ((String)object3).length() <= 2) continue;
            int n = ((String)(object3 = ((String)object3).substring(2))).indexOf(61);
            object2 = n <= 0 ? object3 : ((String)object3).substring(0, n);
            object = n <= 0 ? null : ((String)object3).substring(n + 1);
            treeMap.put(object2, (Object[])object);
        }
        if (treeMap != null) {
            CleanerTransformations cleanerTransformations = new CleanerTransformations();
            object3 = treeMap.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry entry = (Map.Entry)object3.next();
                object2 = (String)entry.getKey();
                object = (Object[])entry.getValue();
                Utils.updateTagTransformations(cleanerTransformations, (String)object2, (String)object);
            }
            htmlCleaner.setTransformations(cleanerTransformations);
        }
        long l = System.currentTimeMillis();
        object2 = string3.toLowerCase();
        TagNode tagNode = ((String)object2).startsWith("http://") || ((String)object2).startsWith("https://") ? htmlCleaner.clean(new URL((String)object2), string2) : htmlCleaner.clean(new File((String)object2), string2);
        if (!"".equals(string26)) {
            int n;
            object = tagNode.evaluateXPath(string26);
            for (n = 0; n < ((Object[])object).length; ++n) {
                if (!(object[n] instanceof TagNode)) continue;
                tagNode = (TagNode)object[n];
                System.out.println("Node successfully found by XPath.");
                break;
            }
            if (n == ((Object[])object).length) {
                System.out.println("Node not found by XPath expression - whole html tree is going to be serialized!");
            }
        }
        object = string4 == null || "".equals(string4.trim()) ? System.out : new FileOutputStream(string4);
        if ("compact".equals(string5)) {
            new CompactXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, string);
        } else if ("browser-compact".equals(string5)) {
            new BrowserCompactXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, string);
        } else if ("pretty".equals(string5)) {
            new PrettyXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, string);
        } else {
            new SimpleXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, string);
        }
        System.out.println("Finished successfully in " + (System.currentTimeMillis() - l) + "ms.");
    }
}

