/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener.chaining;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.StackableChainingListener;

public class ListenerChain {
    private Map<Class<? extends ChainingListener>, Stack<ChainingListener>> listeners = new HashMap<Class<? extends ChainingListener>, Stack<ChainingListener>>();
    private List<Class<? extends ChainingListener>> nextListeners = new ArrayList<Class<? extends ChainingListener>>();

    public void addListener(ChainingListener listener) {
        Stack<ChainingListener> stack = this.listeners.get(listener.getClass());
        if (stack == null) {
            stack = new Stack();
            this.listeners.put(listener.getClass(), stack);
            this.nextListeners.add(listener.getClass());
        }
        stack.push(listener);
    }

    public void removeListener(Class<? extends ChainingListener> listenerClass) {
        this.listeners.remove(listenerClass);
        this.nextListeners.remove(listenerClass);
    }

    public ChainingListener getNextListener(Class<? extends ChainingListener> listenerClass) {
        ChainingListener next = null;
        int pos = this.indexOf(listenerClass);
        if (pos > -1 && this.nextListeners.size() > pos + 1) {
            next = this.listeners.get(this.nextListeners.get(pos + 1)).peek();
        }
        return next;
    }

    public ChainingListener getListener(Class<? extends ChainingListener> listenerClass) {
        return this.listeners.get(listenerClass).peek();
    }

    public int indexOf(Class<? extends ChainingListener> listenerClass) {
        return this.nextListeners.indexOf(listenerClass);
    }

    public void pushListener(Class<? extends ChainingListener> listenerClass) {
        if (StackableChainingListener.class.isAssignableFrom(listenerClass)) {
            Stack<ChainingListener> stack = this.listeners.get(listenerClass);
            stack.push(((StackableChainingListener)stack.peek()).createChainingListenerInstance());
        }
    }

    public void pushAllStackableListeners() {
        for (Class<? extends ChainingListener> listenerClass : this.listeners.keySet()) {
            this.pushListener(listenerClass);
        }
    }

    public void popAllStackableListeners() {
        for (Class<? extends ChainingListener> listenerClass : this.listeners.keySet()) {
            this.popListener(listenerClass);
        }
    }

    public void popListener(Class<? extends ChainingListener> listenerClass) {
        if (StackableChainingListener.class.isAssignableFrom(listenerClass)) {
            this.listeners.get(listenerClass).pop();
        }
    }
}

