/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.listener.descriptor;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptorManager;
import org.xwiki.rendering.listener.descriptor.ListenerElement;

@Component
public class DefaultListenerDescriptorManager
implements ListenerDescriptorManager {
    private static final String PREFIX_BEGIN = "begin";
    private static final String PREFIX_END = "end";
    private static final String PREFIX_ON = "on";
    private Map<Class<?>, ListenerDescriptor> descriptors = new ConcurrentHashMap();

    @Override
    public ListenerDescriptor getListenerDescriptor(Class<?> type) {
        ListenerDescriptor descriptor = this.descriptors.get(type);
        if (descriptor == null) {
            descriptor = this.createDescriptor(type);
            this.descriptors.put(type, descriptor);
        }
        return descriptor;
    }

    public ListenerDescriptor createDescriptor(Class<?> type) {
        ListenerDescriptor descriptor = new ListenerDescriptor();
        for (Method method : Listener.class.getMethods()) {
            String methodName = method.getName();
            String elementName = methodName.startsWith(PREFIX_BEGIN) ? methodName.substring(PREFIX_BEGIN.length(), methodName.length()) : (methodName.startsWith(PREFIX_END) ? methodName.substring(PREFIX_END.length(), methodName.length()) : (methodName.startsWith(PREFIX_ON) ? methodName.substring(PREFIX_ON.length(), methodName.length()) : null));
            if (elementName == null) continue;
            elementName = Character.toLowerCase(elementName.charAt(0)) + elementName.substring(1, elementName.length());
            ListenerElement element = descriptor.getElements().get(elementName.toLowerCase());
            if (element == null) {
                element = new ListenerElement(elementName);
                for (Type parameterType : method.getGenericParameterTypes()) {
                    element.getParameters().add(parameterType);
                }
                descriptor.getElements().put(elementName.toLowerCase(), element);
            }
            if (methodName.startsWith(PREFIX_BEGIN)) {
                element.setBeginMethod(method);
                continue;
            }
            if (methodName.startsWith(PREFIX_END)) {
                element.setEndMethod(method);
                continue;
            }
            element.setOnMethod(method);
        }
        return descriptor;
    }
}

