/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.StringReferenceSeparators;
import org.xwiki.model.reference.EntityReference;

@Component
public class DefaultStringEntityReferenceSerializer
extends AbstractStringEntityReferenceSerializer {
    @Override
    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        EntityType currentType = currentReference.getType();
        EntityReference currentParent = currentReference.getParent();
        String[] currentEscapeChars = StringReferenceSeparators.ESCAPES.get((Object)currentType);
        if (currentParent != null && representation.length() > 0) {
            if (currentParent.getType() == EntityType.WIKI) {
                representation.append(StringReferenceSeparators.WIKISEP);
            } else {
                representation.append(currentEscapeChars[0]);
            }
        }
        if (currentEscapeChars != null) {
            representation.append(StringUtils.replaceEach((String)currentReference.getName(), (String[])currentEscapeChars, (String[])StringReferenceSeparators.REPLACEMENTS.get((Object)currentType)));
        } else {
            representation.append(currentReference.getName().replace(StringReferenceSeparators.ESCAPE, StringReferenceSeparators.DBLESCAPE));
        }
    }
}

