/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class ObjectReference
extends EntityReference {
    public ObjectReference(EntityReference reference) {
        super(reference.getName(), reference.getType(), reference.getParent());
    }

    public ObjectReference(String wiki, String space, String document, String objectName) {
        this(objectName, new DocumentReference(wiki, space, document));
    }

    public ObjectReference(String objectName, DocumentReference documentReference) {
        super(objectName, EntityType.OBJECT, documentReference);
    }

    public void setType(EntityType type) {
        if (type != EntityType.OBJECT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an object reference");
        }
        super.setType(EntityType.OBJECT);
    }

    public void setParent(EntityReference parent) {
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] for an object reference");
        }
        super.setParent(new DocumentReference(parent));
    }
}

