/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.util.HashMap;
import org.wikimodel.wem.IWikiParser;
import org.wikimodel.wem.xhtml.XhtmlParser;
import org.wikimodel.wem.xhtml.handler.CommentHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.wikimodel.AbstractWikiModelParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XHTMLXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiCommentHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiDivisionTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiImageTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiReferenceTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiSpanTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiTableDataTagHandler;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.xml.XMLReaderFactory;

@Component(value="xhtml/1.0")
public class WikiModelXHTMLParser
extends AbstractWikiModelParser {
    @Requirement(value="xwiki/2.0")
    private StreamParser xwikiParser;
    @Requirement(value="link")
    private ResourceReferenceParser linkReferenceParser;
    @Requirement(value="image")
    private ResourceReferenceParser imageReferenceParser;
    @Requirement(value="xwiki/2.1")
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;
    @Requirement
    private ComponentManager componentManager;
    @Requirement(value="xhtmlmarker")
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    @Requirement(value="xwiki")
    private XMLReaderFactory xmlReaderFactory;

    public Syntax getSyntax() {
        return Syntax.XHTML_1_0;
    }

    public StreamParser getLinkLabelParser() {
        return this.xwikiParser;
    }

    public IWikiParser createWikiModelParser() throws ParseException {
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", (Object)handler);
        handlers.put("h2", (Object)handler);
        handlers.put("h3", (Object)handler);
        handlers.put("h4", (Object)handler);
        handlers.put("h5", (Object)handler);
        handlers.put("h6", (Object)handler);
        handlers.put("a", (Object)new XWikiReferenceTagHandler(this, this.xwikiSyntaxPrintRendererFactory));
        handlers.put("img", (Object)new XWikiImageTagHandler());
        handlers.put("span", (Object)new XWikiSpanTagHandler());
        handlers.put("div", (Object)new XWikiDivisionTagHandler());
        handlers.put("th", (Object)new XWikiTableDataTagHandler());
        XhtmlParser parser = new XhtmlParser();
        parser.setExtraHandlers(handlers);
        parser.setCommentHandler((CommentHandler)new XWikiCommentHandler(this.componentManager, this, this.getImageReferenceParser(), this.xwikiSyntaxPrintRendererFactory, this.xhtmlMarkerResourceReferenceParser));
        try {
            parser.setXmlReader(this.xmlReaderFactory.createXMLReader());
        }
        catch (Exception e) {
            throw new ParseException("Failed to create XML reader", (Throwable)e);
        }
        return parser;
    }

    public ResourceReferenceParser getLinkReferenceParser() {
        return this.linkReferenceParser;
    }

    public ResourceReferenceParser getImageReferenceParser() {
        return this.imageReferenceParser;
    }

    public XWikiGeneratorListener createXWikiGeneratorListener(Listener listener, IdGenerator idGenerator) {
        return new XHTMLXWikiGeneratorListener(this.getLinkLabelParser(), listener, this.getLinkReferenceParser(), this.getImageReferenceParser(), this.plainRendererFactory, idGenerator);
    }
}

