/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentReference
extends EntityReference {
    public DocumentReference(EntityReference reference) {
        super(reference.getName(), reference.getType(), reference.getParent());
    }

    public DocumentReference(String wikiName, String spaceName, String pageName) {
        this(pageName, new SpaceReference(spaceName, new WikiReference(wikiName)));
    }

    public DocumentReference(String wikiName, List<String> spaceNames, String pageName) {
        super(pageName, EntityType.DOCUMENT, DocumentReference.constructSpaceReference(wikiName, spaceNames));
    }

    public DocumentReference(String pageName, SpaceReference parent) {
        super(pageName, EntityType.DOCUMENT, parent);
    }

    @Override
    public void setParent(EntityReference parent) {
        if (parent == null || parent.getType() != EntityType.SPACE) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] for a document reference");
        }
        super.setParent(new SpaceReference(parent));
    }

    @Override
    public void setType(EntityType type) {
        if (type != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a document reference");
        }
        super.setType(EntityType.DOCUMENT);
    }

    public WikiReference getWikiReference() {
        return (WikiReference)this.extractReference(EntityType.WIKI);
    }

    public void setWikiReference(WikiReference newWikiReference) {
        EntityReference wikiReference = this.extractReference(EntityType.WIKI);
        wikiReference.getChild().setParent(newWikiReference);
    }

    public SpaceReference getLastSpaceReference() {
        return (SpaceReference)this.extractReference(EntityType.SPACE);
    }

    public List<SpaceReference> getSpaceReferences() {
        ArrayList<SpaceReference> references = new ArrayList<SpaceReference>();
        for (EntityReference reference = this; reference != null; reference = reference.getParent()) {
            if (reference.getType() != EntityType.SPACE) continue;
            references.add((SpaceReference)reference);
        }
        Collections.reverse(references);
        return references;
    }

    private static final EntityReference constructSpaceReference(String wikiName, List<String> spaceNames) {
        EntityReference spaceReference = null;
        EntityReference parent = new EntityReference(wikiName, EntityType.WIKI);
        for (String spaceName : spaceNames) {
            parent = spaceReference = new EntityReference(spaceName, EntityType.SPACE, parent);
        }
        return spaceReference;
    }
}

