/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs.impl;

import java.util.List;
import org.suigeneris.jrcs.diff.PatchFailedException;
import org.suigeneris.jrcs.rcs.BranchNotFoundException;
import org.suigeneris.jrcs.rcs.InvalidFileFormatException;
import org.suigeneris.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.BranchNode;
import org.suigeneris.jrcs.rcs.impl.Line;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.rcs.impl.NodeNotFoundException;

public class TrunkNode
extends Node {
    TrunkNode(TrunkNode other) {
        super(other);
    }

    public TrunkNode(Version vernum, TrunkNode next) throws InvalidTrunkVersionNumberException {
        super(vernum, next);
        if (vernum.size() > 2) {
            throw new InvalidTrunkVersionNumberException(vernum);
        }
    }

    public void setRCSNext(Node node) {
        super.setRCSNext(node);
        if (this.getParent() != null) {
            this.getParent().child = null;
        }
        this.parent = node;
        if (this.getParent() != null) {
            this.getParent().child = this;
        }
    }

    public Node deltaRevision() {
        return this.getChild() != null ? this.getChild() : this;
    }

    public Node nextInPathTo(Version vernum, boolean soft) throws NodeNotFoundException {
        Version branchPoint = vernum.getBase(2);
        if (this.version.isLessThan(branchPoint)) {
            if (soft) {
                return null;
            }
            throw new NodeNotFoundException(vernum);
        }
        Version thisBase = this.version.getBase(branchPoint.size());
        if (thisBase.isGreaterThan(branchPoint)) {
            return this.getParent();
        }
        if (vernum.size() > this.version.size()) {
            BranchNode branch = this.getBranch(vernum.at(this.version.size()));
            if (branch != null || soft) {
                return branch;
            }
            throw new BranchNotFoundException(vernum.getBase(this.version.size() + 1));
        }
        return null;
    }

    protected void patch0(List original, boolean annotate) throws InvalidFileFormatException, NodeNotFoundException, PatchFailedException {
        Object[] lines = this.getText();
        Node root = this.root();
        for (int it = 0; it < lines.length; ++it) {
            original.add(new Line(root, lines[it]));
        }
        if (annotate && this.getParent() != null) {
            this.getParent().pathTo(root.version).patch(original, true);
        }
    }
}

