/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlock
implements Block {
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private List<Block> childrenBlocks = new ArrayList<Block>();
    private Block parentBlock;
    private Block nextSiblingBlock;
    private Block previousSiblingBlock;

    public AbstractBlock() {
    }

    public AbstractBlock(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    @Override
    public void addChild(Block blockToAdd) {
        this.insertChildAfter(blockToAdd, null);
    }

    @Override
    public void addChildren(List<? extends Block> blocksToAdd) {
        for (Block block : blocksToAdd) {
            this.addChild(block);
        }
    }

    @Override
    public void setNextSiblingBlock(Block nextSiblingBlock) {
        this.nextSiblingBlock = nextSiblingBlock;
    }

    @Override
    public void setPreviousSiblingBlock(Block previousSiblingBlock) {
        this.previousSiblingBlock = previousSiblingBlock;
    }

    @Override
    public void insertChildBefore(Block blockToInsert, Block nextBlock) {
        blockToInsert.setParent(this);
        if (nextBlock == null) {
            if (!this.childrenBlocks.isEmpty()) {
                Block lastBlock = this.childrenBlocks.get(this.childrenBlocks.size() - 1);
                blockToInsert.setPreviousSiblingBlock(lastBlock);
                lastBlock.setNextSiblingBlock(blockToInsert);
            } else {
                blockToInsert.setPreviousSiblingBlock(null);
            }
            blockToInsert.setNextSiblingBlock(null);
            this.childrenBlocks.add(blockToInsert);
        } else {
            Block previousBlock = nextBlock.getPreviousSibling();
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(blockToInsert);
                blockToInsert.setPreviousSiblingBlock(previousBlock);
            } else {
                blockToInsert.setPreviousSiblingBlock(null);
            }
            blockToInsert.setNextSiblingBlock(nextBlock);
            nextBlock.setPreviousSiblingBlock(blockToInsert);
            this.childrenBlocks.add(this.indexOfChild(nextBlock), blockToInsert);
        }
    }

    @Override
    public void insertChildAfter(Block blockToInsert, Block previousBlock) {
        if (previousBlock == null) {
            this.insertChildBefore(blockToInsert, null);
        } else {
            Block nextBlock = previousBlock.getNextSibling();
            if (nextBlock != null) {
                nextBlock.setPreviousSiblingBlock(blockToInsert);
                blockToInsert.setNextSiblingBlock(nextBlock);
            } else {
                blockToInsert.setNextSiblingBlock(null);
            }
            blockToInsert.setPreviousSiblingBlock(previousBlock);
            previousBlock.setNextSiblingBlock(blockToInsert);
            this.childrenBlocks.add(this.indexOfChild(previousBlock) + 1, blockToInsert);
        }
    }

    @Override
    public void replaceChild(Block newBlock, Block oldBlock) {
        this.replaceChild(Collections.singletonList(newBlock), oldBlock);
    }

    @Override
    public void replaceChild(List<Block> newBlocks, Block oldBlock) {
        int position = this.indexOfChild(oldBlock);
        if (position == -1) {
            throw new InvalidParameterException("Provided Block to replace is not a child");
        }
        List<Block> blocks = this.getChildren();
        blocks.remove(position);
        oldBlock.setParent(null);
        Block previousBlock = oldBlock.getPreviousSibling();
        if (newBlocks.isEmpty()) {
            previousBlock.setNextSiblingBlock(oldBlock.getNextSibling());
        }
        Block lastBlock = null;
        for (Block block : newBlocks) {
            block.setParent(this);
            block.setPreviousSiblingBlock(previousBlock);
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(block);
            }
            previousBlock = block;
            lastBlock = block;
        }
        Block nextBlock = oldBlock.getNextSibling();
        if (nextBlock != null) {
            nextBlock.setPreviousSiblingBlock(lastBlock);
        }
        if (lastBlock != null) {
            lastBlock.setNextSiblingBlock(nextBlock);
        }
        blocks.addAll(position, newBlocks);
        oldBlock.setNextSiblingBlock(null);
        oldBlock.setPreviousSiblingBlock(null);
    }

    private int indexOfChild(Block block) {
        return this.indexOfBlock(block, this.getChildren());
    }

    private int indexOfBlock(Block block, List<Block> blocks) {
        int position = 0;
        for (Block child : blocks) {
            if (child == block) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    @Override
    public List<Block> getChildren() {
        return this.childrenBlocks;
    }

    @Override
    public Block getParent() {
        return this.parentBlock;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    @Override
    public void setParent(Block parentBlock) {
        this.parentBlock = parentBlock;
    }

    @Override
    public Block getRoot() {
        Block block = this;
        while (block.getParent() != null) {
            block = block.getParent();
        }
        return block;
    }

    @Override
    public <T extends Block> List<T> getChildrenByType(Class<T> blockClass, boolean recurse) {
        ArrayList<T> typedBlocks = new ArrayList<T>();
        for (Block block : this.getChildren()) {
            if (blockClass.isAssignableFrom(block.getClass())) {
                typedBlocks.add(blockClass.cast(block));
            }
            if (!recurse || block.getChildren().isEmpty()) continue;
            typedBlocks.addAll(block.getChildrenByType(blockClass, true));
        }
        return typedBlocks;
    }

    @Override
    public <T extends Block> T getPreviousBlockByType(Class<T> blockClass, boolean recurse) {
        if (this.getParent() == null) {
            return null;
        }
        int index = this.indexOfBlock(this, this.getParent().getChildren());
        List<Block> blocks = this.getParent().getChildren();
        for (int i = index - 1; i >= 0; --i) {
            Block previousBlock = blocks.get(i);
            if (!blockClass.isAssignableFrom(previousBlock.getClass())) continue;
            return (T)((Block)blockClass.cast(previousBlock));
        }
        if (blockClass.isAssignableFrom(this.getParent().getClass())) {
            return (T)((Block)blockClass.cast(this.getParent()));
        }
        return recurse ? (T)this.getParent().getPreviousBlockByType(blockClass, true) : null;
    }

    @Override
    public <T extends Block> T getParentBlockByType(Class<T> blockClass) {
        Block parent = this.getParent();
        if (parent == null || blockClass.isAssignableFrom(parent.getClass())) {
            return (T)((Block)blockClass.cast(parent));
        }
        return parent.getParentBlockByType(blockClass);
    }

    @Override
    public Block getNextSibling() {
        return this.nextSiblingBlock;
    }

    @Override
    public Block getPreviousSibling() {
        return this.previousSiblingBlock;
    }

    @Override
    public void removeBlock(Block childBlockToRemove) {
        this.getChildren().remove(childBlockToRemove);
        if (childBlockToRemove != null) {
            Block nextBlock;
            Block previousBlock = childBlockToRemove.getPreviousSibling();
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(childBlockToRemove.getNextSibling());
            }
            if ((nextBlock = childBlockToRemove.getNextSibling()) != null) {
                nextBlock.setPreviousSiblingBlock(previousBlock);
            }
            childBlockToRemove.setNextSiblingBlock(null);
            childBlockToRemove.setPreviousSiblingBlock(null);
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public Block clone() {
        return this.clone(null);
    }

    @Override
    public Block clone(BlockFilter blockFilter) {
        AbstractBlock block;
        try {
            block = (AbstractBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone object", e);
        }
        block.parameters = new LinkedHashMap<String, String>(this.parameters);
        block.childrenBlocks = new ArrayList<Block>(this.childrenBlocks.size());
        for (Block childBlock : this.childrenBlocks) {
            if (blockFilter != null) {
                Block clonedChildBlocks = childBlock.clone(blockFilter);
                List<Block> filteredBlocks = blockFilter.filter(clonedChildBlocks);
                if (filteredBlocks.size() == 0) {
                    filteredBlocks = clonedChildBlocks.getChildren();
                }
                block.addChildren(filteredBlocks);
                continue;
            }
            block.addChild(childBlock.clone());
        }
        return block;
    }
}

