/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml;

import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.IWikiParser;
import org.wikimodel.wem.WikiParserException;
import org.wikimodel.wem.impl.WikiScannerContext;
import org.wikimodel.wem.xhtml.filter.AccumulationXMLFilter;
import org.wikimodel.wem.xhtml.filter.DTDXMLFilter;
import org.wikimodel.wem.xhtml.filter.XHTMLWhitespaceXMLFilter;
import org.wikimodel.wem.xhtml.handler.CommentHandler;
import org.wikimodel.wem.xhtml.handler.TagHandler;
import org.wikimodel.wem.xhtml.impl.LocalEntityResolver;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XhtmlParser
implements IWikiParser {
    private Map<String, TagHandler> fExtraHandlers = Collections.emptyMap();
    private CommentHandler fCommentHandler = new CommentHandler();
    private XMLReader fXmlReader;

    public void setExtraHandlers(Map<String, TagHandler> extraHandlers) {
        this.fExtraHandlers = extraHandlers;
    }

    public void setCommentHandler(CommentHandler commentHandler) {
        this.fCommentHandler = commentHandler;
    }

    public void setXmlReader(XMLReader xmlReader) {
        this.fXmlReader = xmlReader;
    }

    public DefaultHandler getHandler(IWemListener listener) {
        WikiScannerContext context = new WikiScannerContext(listener);
        XhtmlHandler handler = new XhtmlHandler(context, this.fExtraHandlers, this.fCommentHandler);
        return handler;
    }

    @Override
    public void parse(Reader reader, IWemListener listener) throws WikiParserException {
        try {
            XMLReader xmlReader = this.getXMLReader();
            DefaultHandler handler = this.getHandler(listener);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setEntityResolver(new LocalEntityResolver());
            xmlReader.setContentHandler(handler);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            InputSource source = new InputSource(reader);
            xmlReader.parse(source);
        }
        catch (Exception e) {
            throw new WikiParserException(e);
        }
    }

    private XMLReader getXMLReader() throws Exception {
        XMLReader reader;
        if (this.fXmlReader != null) {
            reader = this.fXmlReader;
        } else {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            DTDXMLFilter dtdFilter = new DTDXMLFilter(xmlReader);
            AccumulationXMLFilter accumulationFilter = new AccumulationXMLFilter(dtdFilter);
            XHTMLWhitespaceXMLFilter whitespaceFilter = new XHTMLWhitespaceXMLFilter(accumulationFilter);
            reader = whitespaceFilter;
        }
        return reader;
    }
}

