/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.webui.UIWikiAdvanceSearchForm;
import org.exoplatform.wiki.webui.UIWikiAdvanceSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiAdvanceSearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UIWikiAdvanceSearchForm
extends UIForm {
    static final String TEXT = "text".intern();
    static final String WIKIS = "wikis".intern();

    public UIWikiAdvanceSearchForm() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput(TEXT, TEXT, null));
        List wikis = this.renderWikisOptions();
        UIFormSelectBoxWithGroups selectSpaces = new UIFormSelectBoxWithGroups(WIKIS, WIKIS, new ArrayList(wikis));
        selectSpaces.setValue(this.getDefaultSelectWikiValue());
        this.addChild((UIComponent)selectSpaces);
        this.setActions(new String[]{"Search"});
    }

    public void resetWikiSpaces() throws Exception {
        ((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).setOptions(new ArrayList(this.renderWikisOptions())).setValue(this.getDefaultSelectWikiValue());
    }

    public List<SelectOptionGroup> renderWikisOptions() throws Exception {
        ArrayList<SelectOptionGroup> listOptions = new ArrayList<SelectOptionGroup>();
        if (this.getAllWikiOptions().getOptions().size() > 0) {
            listOptions.add(this.getAllWikiOptions());
        }
        if (this.getPortalWikiOptions().getOptions().size() > 0) {
            listOptions.add(this.getPortalWikiOptions());
        }
        if (this.getGroupWikiOptions().getOptions().size() > 0) {
            listOptions.add(this.getGroupWikiOptions());
        }
        if (this.getUserWikiOptions().getOptions().size() > 0) {
            listOptions.add(this.getUserWikiOptions());
        }
        return listOptions;
    }

    public SelectOptionGroup getAllWikiOptions() throws Exception {
        SelectOptionGroup allSpaceOptions = new SelectOptionGroup("");
        allSpaceOptions.addOption(new SelectOption(this.getLabel("AllWikis"), ""));
        allSpaceOptions.addOption(new SelectOption(this.getLabel("AllPortalWikis"), PortalConfig.PORTAL_TYPE));
        allSpaceOptions.addOption(new SelectOption(this.getLabel("AllGroupWikis"), PortalConfig.GROUP_TYPE));
        allSpaceOptions.addOption(new SelectOption(this.getLabel("AllUserWikis"), PortalConfig.USER_TYPE));
        return allSpaceOptions;
    }

    public SelectOptionGroup getPortalWikiOptions() throws Exception {
        SelectOptionGroup portalSpaceOptions = new SelectOptionGroup(this.getLabel("PortalWikis"));
        Collection portalWikis = org.exoplatform.wiki.utils.Utils.getWikisByType((WikiType)WikiType.PORTAL);
        for (Wiki wiki : portalWikis) {
            portalSpaceOptions.addOption(new SelectOption(wiki.getOwner(), PortalConfig.PORTAL_TYPE + "/" + wiki.getOwner()));
        }
        return portalSpaceOptions;
    }

    public SelectOptionGroup getGroupWikiOptions() throws Exception {
        SelectOptionGroup groupSpaceOptions = new SelectOptionGroup(this.getLabel("GroupWikis"));
        Collection groupWikis = org.exoplatform.wiki.utils.Utils.getWikisByType((WikiType)WikiType.GROUP);
        for (Wiki wiki : groupWikis) {
            groupSpaceOptions.addOption(new SelectOption(wiki.getOwner(), PortalConfig.GROUP_TYPE + "/" + org.exoplatform.wiki.utils.Utils.validateWikiOwner((String)wiki.getType(), (String)wiki.getOwner())));
        }
        return groupSpaceOptions;
    }

    public SelectOptionGroup getUserWikiOptions() throws Exception {
        SelectOptionGroup userSpaceOptions = new SelectOptionGroup(this.getLabel("UserWikis"));
        Collection userWikis = org.exoplatform.wiki.utils.Utils.getWikisByType((WikiType)WikiType.USER);
        for (Wiki wiki : userWikis) {
            userSpaceOptions.addOption(new SelectOption(wiki.getOwner(), PortalConfig.USER_TYPE + "/" + wiki.getOwner()));
        }
        return userSpaceOptions;
    }

    public void processSearchAction() throws Exception {
        String[] arrayParams;
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        String text = ((String)this.getUIStringInput(TEXT).getValue()).trim();
        String path = (String)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getValue();
        String wikiType = null;
        String wikiOwner = null;
        if (!CommonUtils.isEmpty((String)path) && (arrayParams = path.split(CommonUtils.SLASH)).length >= 1) {
            wikiType = arrayParams[0];
            if (arrayParams.length >= 2) {
                wikiOwner = StringUtils.replace((String)path, (String)(wikiType + CommonUtils.SLASH), (String)CommonUtils.EMPTY_STR);
            }
        }
        WikiSearchData data = new WikiSearchData(text, null, null, wikiType, wikiOwner);
        PageList results = wservice.search(data);
        UIWikiAdvanceSearchResult uiSearchResults = (UIWikiAdvanceSearchResult)this.getParent().findFirstComponentOfType(UIWikiAdvanceSearchResult.class);
        uiSearchResults.setKeyword(text);
        uiSearchResults.setResult(results);
    }

    private String getDefaultSelectWikiValue() throws Exception {
        WikiPageParams currentParams = Utils.getCurrentWikiPageParams();
        String wikiType = currentParams.getType();
        String owner = currentParams.getOwner();
        return wikiType + "/" + org.exoplatform.wiki.utils.Utils.validateWikiOwner((String)wikiType, (String)owner);
    }
}

