/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.LinkEntry;
import org.exoplatform.wiki.mow.core.api.wiki.LinkRegistry;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.webui.core.UIAdvancePageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiAdvanceSearchResult.gtmpl")
public class UIWikiAdvanceSearchResult
extends UIContainer {
    private String keyword;
    LinkRegistry registry = null;

    public UIWikiAdvanceSearchResult() throws Exception {
        this.addChild(UIAdvancePageIterator.class, null, "SearchResultPageIterator");
    }

    public void setResult(PageList<SearchResult> results) throws Exception {
        UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)this.getChild(UIAdvancePageIterator.class);
        pageIterator.setPageList(results);
        if (pageIterator.getPageList() != null) {
            pageIterator.getPageList().getPage(1);
        }
    }

    public PageList<SearchResult> getResults() {
        UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)this.getChild(UIAdvancePageIterator.class);
        return pageIterator.getPageList();
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    private String getKeyword() {
        return this.keyword;
    }

    private String getDateFormat(Calendar cal) throws Exception {
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 3, currentLocale);
        return df.format(cal.getTime());
    }

    private Wiki getWiki(SearchResult result) throws Exception {
        Wiki searchWiki = null;
        try {
            if ("wiki:content".equals(result.getType()) || "wiki:attachment".equals(result.getType())) {
                AttachmentImpl searchContent = (AttachmentImpl)Utils.getObject((String)result.getPath(), (String)"wiki:attachment");
                searchWiki = searchContent.getParentPage().getWiki();
            } else if ("wiki:page".equals(result.getType()) || "exo:wikihome".equals(result.getType())) {
                PageImpl page = (PageImpl)Utils.getObject((String)result.getPath(), (String)"wiki:page");
                searchWiki = page.getWiki();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return searchWiki;
    }

    private String getPageSearchName(Wiki wiki, String pageTitle) throws Exception {
        if (pageTitle.indexOf(this.keyword) >= 0) {
            return "";
        }
        if (this.registry == null) {
            this.registry = ((WikiImpl)wiki).getLinkRegistry();
        }
        Map linkEntries = this.registry.getLinkEntries();
        ArrayList<LinkEntry> linkEntrys = new ArrayList<LinkEntry>();
        ArrayList<String> alias = new ArrayList<String>();
        block0: for (LinkEntry linkEntry : linkEntries.values()) {
            String titleAfter;
            String titleBefore;
            if (alias.contains(linkEntry.getAlias())) continue;
            do {
                alias.add(linkEntry.getAlias());
                titleAfter = linkEntry.getTitle();
                linkEntrys.add(linkEntry);
                if ((linkEntry = linkEntry.getNewLink()) == null) continue block0;
                titleBefore = linkEntry.getTitle();
                if (CommonUtils.isEmpty((String)titleBefore) || !titleBefore.equals(pageTitle) || !titleAfter.equals(titleBefore)) continue;
                for (LinkEntry entry : linkEntrys) {
                    if (entry.getTitle().indexOf(this.keyword) < 0) continue;
                    return entry.getTitle();
                }
                continue block0;
            } while (!CommonUtils.isEmpty((String)titleBefore) && !titleAfter.equals(titleBefore));
            linkEntrys.clear();
        }
        return "";
    }

    private String getWikiNodeUri(Wiki wiki) throws Exception {
        String wikiType = wiki.getType();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder sb = new StringBuilder(portalRequestContext.getPortalURI());
        UIPortal uiPortal = Util.getUIPortal();
        String pageNodeSelected = uiPortal.getSelectedUserNode().getURI();
        sb.append(pageNodeSelected);
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(wikiType)) {
            sb.append("/");
            sb.append(wikiType);
            sb.append("/");
            sb.append(Utils.validateWikiOwner((String)wikiType, (String)wiki.getOwner()));
        }
        return sb.toString();
    }
}

