/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.Preferences;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.UIWikiSidePanelArea;
import org.exoplatform.wiki.webui.UIWikiTemplateDescriptionContainer;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIEditorTabs;
import org.exoplatform.wiki.webui.control.UISubmitToolBar;
import org.exoplatform.wiki.webui.core.UISyntaxSelectBoxFactory;
import org.exoplatform.wiki.webui.core.UIWikiForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPageEditForm.gtmpl", events={@EventConfig(listeners={SelectSyntaxActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIWikiPageEditForm
extends UIWikiForm {
    public static final String UNTITLED = "Untitled";
    public static final String FIELD_CONTENT = "Markup";
    public static final String FIELD_COMMENT = "Comment";
    public static final String FIELD_SYNTAX = "SyntaxType";
    public static final String TITLE_CONTROL = "UIWikiPageTitleControlForm_PageEditForm";
    public static final String EDITOR_TABS = "UIEditorTabs";
    public static final String SUBMIT_TOOLBAR_UPPER = "UISubmitToolBarUpper";
    public static final String SUBMIT_TOOLBAR_BOTTOM = "UISubmitToolBarBottom";
    public static final String HELP_PANEL = "UIWikiSidePanelArea";
    public static final String RICHTEXT_AREA = "UIWikiRichTextArea";
    public static final String FIELD_TEMPLATEDESCTIPTION = "UIWikiTemplateDescriptionContainer";
    private boolean isTemplate = false;
    private String templateId = "";
    private String title;
    public static final String CLOSE = "Close";

    public UIWikiPageEditForm() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.EDITPAGE, WikiMode.ADDPAGE, WikiMode.EDITTEMPLATE, WikiMode.ADDTEMPLATE);
        ((UIWikiPageTitleControlArea)this.addChild(UIWikiPageTitleControlArea.class, null, TITLE_CONTROL)).toInputMode();
        this.addChild(UISubmitToolBar.class, null, SUBMIT_TOOLBAR_UPPER);
        this.addChild(UIWikiTemplateDescriptionContainer.class, null, FIELD_TEMPLATEDESCTIPTION);
        this.addChild(UIEditorTabs.class, null, EDITOR_TABS);
        this.addChild(UISubmitToolBar.class, null, SUBMIT_TOOLBAR_BOTTOM);
        this.addChild(UIWikiSidePanelArea.class, null, HELP_PANEL);
        ((UIWikiRichTextArea)this.addChild(UIWikiRichTextArea.class, null, RICHTEXT_AREA)).setRendered(false);
        UIFormTextAreaInput markupInput = new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, "");
        this.addUIFormInput((UIFormInput)markupInput).setRendered(true);
        UIFormStringInput commentInput = new UIFormStringInput(FIELD_COMMENT, FIELD_COMMENT, "");
        this.addUIFormInput((UIFormInput)commentInput);
        UIFormSelectBox selectSyntax = UISyntaxSelectBoxFactory.newInstance((String)FIELD_SYNTAX, (String)FIELD_SYNTAX);
        selectSyntax.setOnChange("SelectSyntax");
        this.addChild((UIComponent)selectSyntax);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean isSidePanelRendered() {
        return ((UIWikiSidePanelArea)this.getChild(UIWikiSidePanelArea.class)).isRendered();
    }

    public void reloadSyntax() throws Exception {
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        WikiMode currentMode = this.getCurrentMode();
        UIFormSelectBox syntaxTypeSelectBox = this.getUIFormSelectBox(FIELD_SYNTAX);
        Preferences currentPreferences = ((WikiImpl)Utils.getCurrentWiki()).getPreferences();
        boolean allowSelect = currentPreferences.getPreferencesSyntax().getAllowMutipleSyntaxes();
        syntaxTypeSelectBox.setEnable(allowSelect);
        if (currentMode.equals((Object)WikiMode.ADDPAGE)) {
            String currentDefaultSyntaxt = currentPreferences.getPreferencesSyntax().getDefaultSyntax();
            if (currentDefaultSyntaxt == null) {
                currentDefaultSyntaxt = wservice.getDefaultWikiSyntaxId();
            }
            syntaxTypeSelectBox.setValue(currentDefaultSyntaxt);
        }
    }
}

