/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIFieldEditableForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageTitleControlArea.gtmpl")
public class UIWikiPageTitleControlArea
extends UIContainer {
    public static final String FIELD_TITLEINFO = "TitleInfo";
    public static final String FIELD_TITLEINPUT = "TitleInput";
    public static final String FIELD_EDITABLE = "Editable";
    public static final String CHANGE_TITLEMODE = "ChangeTitleMode";
    public static final String SAVE_TITLE = "saveTitle";

    public UIWikiPageTitleControlArea() throws Exception {
        UIFormInputInfo titleInfo = new UIFormInputInfo(FIELD_TITLEINFO, FIELD_TITLEINFO, FIELD_TITLEINFO);
        titleInfo.setRendered(true);
        this.addChild((UIComponent)titleInfo);
        UIFormStringInput titleInput = new UIFormStringInput(FIELD_TITLEINPUT, FIELD_TITLEINPUT, FIELD_TITLEINPUT);
        titleInput.setRendered(false);
        this.addChild((UIComponent)titleInput);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        WikiMode currentMode;
        List<WikiMode> acceptEdiableModes = Arrays.asList(WikiMode.VIEW, WikiMode.HELP, WikiMode.VIEWREVISION);
        if (acceptEdiableModes.contains(currentMode = ((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode())) {
            if (this.getChild(UIFieldEditableForm.class) == null) {
                this.addChild(UIFieldEditableForm.class, null, FIELD_EDITABLE);
            }
            ((UIFieldEditableForm)this.getChild(UIFieldEditableForm.class)).setEditableFieldId(FIELD_TITLEINFO);
            Class[] arg = new Class[]{String.class, Event.class};
            ((UIFieldEditableForm)this.getChild(UIFieldEditableForm.class)).setParentFunction(SAVE_TITLE, arg);
        }
        super.processRender(context);
    }

    public UIFormInputInfo getUIFormInputInfo() {
        return (UIFormInputInfo)this.findComponentById(FIELD_TITLEINFO);
    }

    public UIFormStringInput getUIStringInput() {
        return (UIFormStringInput)this.findComponentById(FIELD_TITLEINPUT);
    }

    public void toInfoMode() {
        this.findComponentById(FIELD_TITLEINFO).setRendered(true);
        this.findComponentById(FIELD_TITLEINPUT).setRendered(false);
    }

    public void toInputMode() {
        this.findComponentById(FIELD_TITLEINFO).setRendered(false);
        this.findComponentById(FIELD_TITLEINPUT).setRendered(true);
    }

    public boolean isInfoMode() {
        return this.getChildById(FIELD_TITLEINFO).isRendered();
    }

    public void saveTitle(String newTitle, Event event) throws Exception {
        boolean isRenameHome;
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        String newName = TitleResolver.getId((String)newTitle, (boolean)true);
        Page page = Utils.getCurrentWikiPage();
        boolean bl = isRenameHome = "WikiHome".equals(page.getName()) && !newName.equals(pageParams.getPageId());
        if (isRenameHome) {
            page.setTitle(newTitle);
        } else {
            wikiService.renamePage(pageParams.getType(), pageParams.getOwner(), pageParams.getPageId(), newName, newTitle);
        }
        pageParams.setPageId(newName);
        Utils.redirect((WikiPageParams)pageParams, (WikiMode)WikiMode.VIEW);
    }

    private boolean isAddMode() {
        WikiMode currentMode = ((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode();
        return currentMode.equals((Object)WikiMode.ADDPAGE);
    }

    public String getTitle() {
        return (String)((UIFormStringInput)this.getChild(UIFormStringInput.class)).getValue();
    }
}

