/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.wiki.service.Permission;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.webui.UIWikiPermissionEntry;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPermissionEntry.gtmpl")
public class UIWikiPermissionEntry
extends UIContainer {
    private static final String ANY_OWNER = "any";
    private static final Log log = ExoLogger.getLogger(UIWikiPermissionEntry.class);
    private PermissionEntry permissionEntry;

    public PermissionEntry getPermissionEntry() {
        return this.permissionEntry;
    }

    public void setPermissionEntry(PermissionEntry permissionEntry) {
        this.permissionEntry = permissionEntry;
        this.getChildren().clear();
        if (this.permissionEntry == null) {
            return;
        }
        Permission[] permissions = this.permissionEntry.getPermissions();
        for (int i = 0; i < permissions.length; ++i) {
            this.addChild((UIComponent)new UIFormCheckBoxInput(permissions[i].getPermissionType().toString() + this.permissionEntry.getId(), "", (Object)permissions[i].isAllowed()).setValue((Object)permissions[i].isAllowed()));
        }
    }

    public String getEntryFullName() {
        block10: {
            if (this.permissionEntry.getFullName() != null) {
                return this.permissionEntry.getFullName();
            }
            String id = this.permissionEntry.getId();
            if (ANY_OWNER.equals(id)) {
                this.permissionEntry.setFullName(id);
                return this.permissionEntry.getFullName();
            }
            OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            try {
                switch (1.$SwitchMap$org$exoplatform$wiki$service$IDType[this.permissionEntry.getIdType().ordinal()]) {
                    case 1: {
                        UserHandler userHandler = organizationService.getUserHandler();
                        this.permissionEntry.setFullName(userHandler.findUserByName(id).getFullName());
                        break;
                    }
                    case 2: {
                        GroupHandler groupHandler = organizationService.getGroupHandler();
                        this.permissionEntry.setFullName(groupHandler.findGroupById(id).getGroupName());
                        break;
                    }
                    case 3: {
                        int index = id.indexOf(58);
                        if (index == -1) {
                            this.permissionEntry.setFullName(id);
                            break;
                        }
                        String membership = id.split(":")[0];
                        String groupId = id.split(":")[1];
                        GroupHandler groupHandler1 = organizationService.getGroupHandler();
                        String groupName = groupHandler1.findGroupById(groupId).getGroupName();
                        groupName = groupName.substring(0, 1).toUpperCase() + groupName.substring(1);
                        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                        String key = context.getApplicationResourceBundle().getString("UIWikiPermissionForm.PermissionEntry.fullName");
                        this.permissionEntry.setFullName(key.replace("{0}", membership).replace("{1}", groupName));
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)"Exception when determineFullName", (Throwable)ex);
            }
        }
        return this.permissionEntry.getFullName();
    }
}

