/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.bean.TemplateBean;
import org.exoplatform.wiki.webui.bean.WikiTemplateListAccess;
import org.exoplatform.wiki.webui.commons.UIWikiTemplateForm;
import org.exoplatform.wiki.webui.commons.UIWikiTemplateGrid;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/commons/UIWikiTemplateForm.gtmpl", events={@EventConfig(listeners={SearchTemplateActionListener.class})})
public class UIWikiTemplateForm
extends UIForm {
    public static final String TEMPLATE_SEARCHBOX = "TemplateSeachBox";
    public static final String TEMPLATE_GRID = "UIWikiTemplateGrid";
    public static final String TEMPLATE_ITER = "TemplateIter";
    public static final int ITEMS_PER_PAGE = 8;
    public static final String TEMPLATE_ID = "id";
    public static final String TEMPLATE_NAME = "title";
    public static final String DESCRIPTION = "description";
    public static final String[] TEMPLATE_FIELD = new String[]{"title", "description"};
    public UIGrid grid;
    public WikiService wService;
    public ResourceBundle res;

    public UIWikiTemplateForm() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.res = context.getApplicationResourceBundle();
        this.addChild((UIComponent)new UIFormStringInput(TEMPLATE_SEARCHBOX, null, this.res.getString("UITemplateSettingForm.label.Search")));
        this.grid = (UIGrid)this.addChild(UIWikiTemplateGrid.class, null, TEMPLATE_GRID);
        this.grid.getUIPageIterator().setId(TEMPLATE_ITER);
        this.grid.getUIPageIterator().setParent((UIComponent)this);
        this.wService = (WikiService)PortalContainer.getComponent(WikiService.class);
        this.grid.configure(TEMPLATE_ID, TEMPLATE_FIELD, null);
        this.initGrid();
    }

    public void initGrid() throws Exception {
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        Iterator iter = this.wService.getTemplates(params).entrySet().iterator();
        ArrayList<TemplateBean> listBean = new ArrayList<TemplateBean>();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Template template = (Template)entry.getValue();
            listBean.add(new TemplateBean(template.getName(), template.getTitle(), template.getDescription()));
        }
        LazyPageList lazylist = new LazyPageList((ListAccess)new WikiTemplateListAccess(listBean), 8);
        this.grid.getUIPageIterator().setPageList((PageList)lazylist);
    }
}

