/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.control.UIRelatedPagesContainer;
import org.exoplatform.wiki.webui.control.action.RemoveRelatedPageActionComponent;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={RemoveRelatedPageActionListener.class}, confirm="UIWikiPageInfo.msg.confirm-remove-rpage")})
public class RemoveRelatedPageActionComponent
extends UIComponent {
    private static final Log log = ExoLogger.getLogger(UIRelatedPagesContainer.class);
    public static final String WIKI_TYPE = "wikitype";
    public static final String PAGE_OWNER = "owner";
    public static final String PAGE_ID = "pageid";
    public static final String ACTION = "RemoveRelatedPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new EditPagesPermissionFilter());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    String getRemovePageActionLink(WikiPageParams wikiParams) {
        Parameter[] params = new Parameter[]{new Parameter(WIKI_TYPE, wikiParams.getType()), new Parameter(PAGE_OWNER, wikiParams.getOwner()), new Parameter(PAGE_ID, wikiParams.getPageId())};
        try {
            return this.event(ACTION, null, params);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"getting Remove related page failed", (Throwable)e);
            }
            return "";
        }
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

