/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.webui.popup.UIWikiSelectPageForm;
import org.exoplatform.wiki.webui.tree.EventUIComponent;
import org.exoplatform.wiki.webui.tree.UITreeExplorer;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="/templates/wiki/webui/popup/UIWikiSelectPageForm.gtmpl", events={@EventConfig(listeners={SetCurrentPageActionListener.class}), @EventConfig(listeners={SelectPageActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiSelectPageForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getLogger(UIWikiSelectPageForm.class);
    public static final String FORM_ID = "UIWikiSelectPageForm";
    private String currentNodeValue = "";
    public static final String UI_TREE_ID = "UIPageTree";
    private List<UIComponent> updatedComponents = new ArrayList();

    public UIWikiSelectPageForm() throws Exception {
        this.setId(FORM_ID);
        UITreeExplorer uiTree = (UITreeExplorer)this.addChild(UITreeExplorer.class, null, UI_TREE_ID);
        EventUIComponent eventComponent = new EventUIComponent(FORM_ID, "SetCurrentPage", EventUIComponent.EVENTTYPE.EVENT);
        StringBuilder initURLSb = new StringBuilder(Utils.getCurrentRestURL());
        initURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.ALL.toString());
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.CHILDREN.toString());
        uiTree.init(initURLSb.toString(), childrenURLSb.toString(), this.getInitParam(), eventComponent);
    }

    public void addUpdatedComponent(UIComponent component) {
        this.updatedComponents.add(component);
    }

    public void removeUpdatedComponent(UIComponent component) {
        this.updatedComponents.remove(component);
    }

    private String getInitParam() throws Exception {
        StringBuilder sb = new StringBuilder();
        String currentPath = Utils.getCurrentWikiPagePath();
        sb.append("?").append("path").append("=").append(currentPath).append("&").append("page").append("=").append(currentPath);
        return sb.toString();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ String access$002(UIWikiSelectPageForm x0, String x1) {
        x0.currentNodeValue = x1;
        return x0.currentNodeValue;
    }

    static /* synthetic */ String access$000(UIWikiSelectPageForm x0) {
        return x0.currentNodeValue;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ List access$200(UIWikiSelectPageForm x0) {
        return x0.updatedComponents;
    }
}

