/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.exoplatform.wiki.IWikiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExoWikiHandler
implements IWikiHandler {
    public static final String CHAR_TO_REPLACE = "*'\"+?&";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExoWikiHandler.class.toString());
    private static final String DEFAULT_ENCODING = "UTF-8";
    private DefaultHttpClient httpClient;
    private HttpClient davClient;
    private String targetHost;

    public ExoWikiHandler(String targetHost) {
        this.targetHost = targetHost;
    }

    public void start(String targetUser, String targetPwd) {
        this.httpClient = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(targetUser, targetPwd);
        this.httpClient.getCredentialsProvider().setCredentials(org.apache.http.auth.AuthScope.ANY, (org.apache.http.auth.Credentials)creds);
        this.davClient = new HttpClient();
        this.davClient.getState().setCredentials(AuthScope.ANY, (Credentials)new org.apache.commons.httpclient.UsernamePasswordCredentials(targetUser, targetPwd));
    }

    public void stop() {
        this.httpClient.getConnectionManager().shutdown();
        this.davClient.getHttpConnectionManager().closeIdleConnections(1000L);
    }

    public String createPage(String path, String pageName, boolean hasChildren, String syntax) {
        String createdPageName = null;
        try {
            String normalizedPageTitle = this.normalizePageName(pageName, false);
            String normalizePageName = this.normalizePageName(pageName, true);
            int statusCode = this.getHttpStatusOfPageOnTarget(path, normalizePageName);
            if (statusCode == 404) {
                HttpGet httpGet = new HttpGet(this.targetHost + "/rest/wikiloader/create?path=" + URLEncoder.encode(path, DEFAULT_ENCODING) + "&name=" + URLEncoder.encode(normalizedPageTitle, DEFAULT_ENCODING) + "&syntax=" + syntax);
                HttpResponse responseCreate = this.httpClient.execute((HttpUriRequest)httpGet);
                int statusCodeRC1 = responseCreate.getStatusLine().getStatusCode();
                if (statusCodeRC1 == 200) {
                    createdPageName = IOUtils.toString((InputStream)responseCreate.getEntity().getContent());
                    if (createdPageName.startsWith("%%")) {
                        LOGGER.error(String.format("[Create] Failed to create [Err = %s] - Cause: %s", "" + statusCodeRC1, createdPageName));
                        return null;
                    }
                } else {
                    String message = "";
                    if (responseCreate != null && responseCreate.getEntity() != null) {
                        message = IOUtils.toString((InputStream)responseCreate.getEntity().getContent());
                    }
                    LOGGER.error(String.format("[Create] Failed to create [Err = %i] - Cause: %s", statusCodeRC1, message));
                    return null;
                }
                HttpGet httpCheckCreated = new HttpGet(this.targetHost + "/rest/private/wikiloader/check?path=" + URLEncoder.encode(path + "/" + createdPageName, DEFAULT_ENCODING));
                HttpResponse responseCheck2 = this.httpClient.execute((HttpUriRequest)httpCheckCreated);
                int statusCodeRC2 = responseCheck2.getStatusLine().getStatusCode();
                responseCheck2.getEntity().consumeContent();
                if (statusCodeRC2 != 200) {
                    LOGGER.info(String.format("[Create] Created page %s/%s not found.", path, pageName));
                    return pageName;
                }
                return createdPageName;
            }
            if (statusCode == 200) {
                LOGGER.warn(String.format("[Create] Page already created", new Object[0]));
                return null;
            }
        }
        catch (Exception exception) {
            LOGGER.error(String.format("[Create] Error creating page. Err = ", exception.getMessage()));
        }
        return null;
    }

    public int getHttpStatusOfPageOnTarget(String path, String pageName) throws IOException {
        HttpGet httpCheck = new HttpGet(this.targetHost + "/rest/wikiloader/check?path=" + URLEncoder.encode(path + "/" + pageName, DEFAULT_ENCODING));
        HttpResponse responseCheck = this.httpClient.execute((HttpUriRequest)httpCheck);
        int statusCode = responseCheck.getStatusLine().getStatusCode();
        responseCheck.getEntity().consumeContent();
        return statusCode;
    }

    public boolean transferContent(String content, String path) {
        try {
            HttpPost httppost = new HttpPost(this.targetHost + "/rest/private/wikiloader/content");
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("path", path));
            formparams.add(new BasicNameValuePair("content", content));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, DEFAULT_ENCODING);
            httppost.setEntity((HttpEntity)entity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);
            response.getEntity().consumeContent();
        }
        catch (IOException exception) {
            LOGGER.error("[Transfert] Error uploading content to : " + path);
        }
        return true;
    }

    public boolean checkPageExists(String path) {
        try {
            HttpGet httpGet = new HttpGet(this.targetHost + "/rest/private/wikiloader/pageurl?path=" + URLEncoder.encode(path, DEFAULT_ENCODING));
            HttpResponse responseGet = this.httpClient.execute((HttpUriRequest)httpGet);
            responseGet.getEntity().consumeContent();
            return responseGet.getStatusLine().getStatusCode() == 200;
        }
        catch (IOException exception) {
            LOGGER.error("[URL] Error getting Url for : " + path);
            return false;
        }
    }

    public boolean uploadAttachment(String targetSpace, String pageName, String attachmentName, String contentType, InputStream stream) {
        try {
            this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            HttpPost post = new HttpPost(this.targetHost + "/rest/wikiloader/upload/" + targetSpace + "/" + this.normalizePageName(pageName, true) + "/");
            MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntity.addPart("File", (ContentBody)new InputStreamBody(stream, contentType, this.normalizePageName(attachmentName, true)));
            post.setEntity((HttpEntity)multipartEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String responsePhrase = IOUtils.toString((InputStream)response.getEntity().getContent());
            int statusCode = response.getStatusLine().getStatusCode();
            LOGGER.info("[Upload] attachment : " + statusCode + " - " + responsePhrase);
            if (statusCode == 200) {
                return !responsePhrase.startsWith("%%");
            }
            LOGGER.error("[Upload] attachment fail : " + statusCode + " - " + responsePhrase);
        }
        catch (IOException exception) {
            LOGGER.error("[Upload] attachment fail");
        }
        return false;
    }

    public boolean checkAttachmentExists(String targetSpace, String pageName, String attachmentName) {
        try {
            String[] attachments;
            String normalizedPageName = this.normalizePageName(pageName, true);
            String normalizedAttachmentName = this.normalizePageName(attachmentName, true);
            String path = targetSpace + "/" + normalizedPageName + "/";
            HttpGet httpGet = new HttpGet(this.targetHost + "/rest/wikiloader/attachments/" + path);
            HttpResponse responseGet = this.httpClient.execute((HttpUriRequest)httpGet);
            String response = IOUtils.toString((InputStream)responseGet.getEntity().getContent());
            for (String att : attachments = response.split("\\|")) {
                if (!att.equals(normalizedAttachmentName)) continue;
                return true;
            }
        }
        catch (IOException exception) {
            LOGGER.error("[URL] Error getting Url for : " + targetSpace);
        }
        return false;
    }

    public boolean uploadDocument(String targetSpace, String path, String name, String contentType, InputStream stream) {
        if (!targetSpace.startsWith("group/spaces/")) {
            return false;
        }
        String space = targetSpace.substring("group/spaces/".length());
        if (space.length() == 0) {
            return false;
        }
        try {
            String targetUrl = this.targetHost + "/rest/private/jcr/repository/collaboration/Groups/spaces/" + space + "/Documents/";
            String filePath = URLEncoder.encode(path, DEFAULT_ENCODING).replaceAll("%2F", "/");
            String uriFile = targetUrl + filePath + "/" + URLEncoder.encode(name, DEFAULT_ENCODING);
            if (this.checkURIExists(uriFile)) {
                LOGGER.error("[Upload] Document already exists [" + path + "/" + name + "], not replaced.");
            } else {
                String uriPath = targetUrl + filePath + "/";
                if (!this.checkURIExists(uriPath)) {
                    String[] pathArray = path.split("/");
                    String pathInProgress = targetUrl;
                    for (String pathElement : pathArray) {
                        MkColMethod mkCol;
                        int returnCode;
                        if (this.checkURIExists(pathInProgress = pathInProgress + URLEncoder.encode(pathElement, DEFAULT_ENCODING) + "/") || (returnCode = this.davClient.executeMethod((HttpMethod)(mkCol = new MkColMethod(pathInProgress)))) == 201) continue;
                        LOGGER.error("[Upload] Error creating directory [" + path + "] [Err:" + returnCode + "]");
                        return false;
                    }
                    LOGGER.info("[Upload] Created directory [" + path + "]");
                }
                PutMethod method = new PutMethod(uriFile);
                InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(stream);
                method.setRequestEntity((RequestEntity)requestEntity);
                int returnCode = this.davClient.executeMethod((HttpMethod)method);
                if (returnCode == 201) {
                    LOGGER.info("[Upload] Document uploaded [" + path + "/" + name + "]");
                } else {
                    LOGGER.info("[Upload] Document NOT uploaded [Err=" + returnCode + "]");
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[Upload] Document upload error [" + path + "/" + name + "] " + e.getMessage());
            return false;
        }
    }

    private boolean checkURIExists(String uriFile) throws IOException, HttpException {
        int returnCode = 0;
        GetMethod propFind = new GetMethod(uriFile);
        returnCode = this.davClient.executeMethod((HttpMethod)propFind);
        this.davClient.getHttpConnectionManager().closeIdleConnections(0L);
        return returnCode == 200;
    }

    public String normalizePageName(String title, boolean replaceSpaces) {
        String replacedChars = CHAR_TO_REPLACE + (replaceSpaces ? " " : "");
        return ExoWikiHandler.normalizePageName(title, replacedChars, '_');
    }

    public static String normalizePageName(String title, String replacedChars, char replacementChar) {
        String newContent = title;
        for (int i = 0; i < replacedChars.length(); ++i) {
            newContent = newContent.replace(replacedChars.charAt(i), replacementChar);
        }
        return newContent;
    }
}

