/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.util;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacroMap {
    private MacroMap() {
    }

    public static void addMacro(Map<String, Integer> macroMap, String ... macros) {
        for (String macro : macros) {
            MacroMap.addMacro(macroMap, macro, 1);
        }
    }

    public static boolean addMacro(Map<String, Integer> macroMap, String macro, int count) {
        boolean newMacro = false;
        if (macroMap == null) {
            return false;
        }
        Integer currentCount = macroMap.get(macro);
        if (currentCount == null) {
            currentCount = count;
            newMacro = true;
        } else {
            currentCount = currentCount + count;
        }
        macroMap.put(macro, currentCount);
        return newMacro;
    }

    public static void mergeMaps(Map<String, Integer> sourceMap, Map<String, Integer> targetMap) {
        for (String macro : sourceMap.keySet()) {
            Integer count = sourceMap.get(macro);
            MacroMap.addMacro(targetMap, macro, count);
        }
    }

    public static int getCount(Map<String, Integer> targetMap, String key) {
        Integer value = targetMap.get(key);
        return value != null ? value : 0;
    }
}

