/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Comment;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Label;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageSummary;
import org.codehaus.swizzle.confluence.SwizzleException;
import org.exoplatform.wiki.ConfluenceCrawlerException;
import org.exoplatform.wiki.CrawlerConstants;
import org.exoplatform.wiki.IWikiHandler;
import org.exoplatform.wiki.handler.ExoWikiHandler;
import org.exoplatform.wiki.handler.WikbookWikiHandler;
import org.exoplatform.wiki.transform.SyntaxTransformer;
import org.exoplatform.wiki.util.MacroExtractor;
import org.exoplatform.wiki.util.MacroMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceCrawler
implements CrawlerConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConfluenceCrawler.class.toString());
    private Confluence confluence;
    private String sourceHost = "";
    private String sourceUser = "";
    private String sourcePwd = "";
    private String sourceSpace;
    private String[] sourcePages;
    private String targetHost;
    private String targetUser;
    private String targetPwd;
    private String targetType;
    private String targetSpace;
    private String targetPage;
    private String targetSyntax;
    private boolean optionRecursiveCrawling = false;
    private boolean optionStopOnFailure = false;
    private boolean optionTransferAttachments = true;
    private boolean optionTransferComments = true;
    private boolean optionTransferLabels = true;
    private int optionMaxAttachmentSize = 2048;
    private String optionUploadAs = "attachment";
    private String crawlerActions = "check";
    private int visitedPages = 0;
    private int transferredPages = 0;
    private int transferredAttachments = 0;
    private List<String> erroredElement = new ArrayList<String>();
    private boolean actionCheckPageEnabled = false;
    private boolean actionTransfertPageEnabled = false;
    private boolean actionSyncAttachments = false;
    private IWikiHandler wikiHandler;
    private final Map<String, Integer> supportedMacrosMap = new HashMap<String, Integer>();
    private final Map<String, Integer> unsupportedMacrosMap = new HashMap<String, Integer>();
    private final Map<String, Integer> unknownMacrosMap = new HashMap<String, Integer>();

    public static void main(String[] args) {
        ConfluenceCrawler cc = new ConfluenceCrawler();
        String propertiesFile = args.length > 0 ? args[0] : "migration.properties";
        String envMigrationFile = System.getProperty("wiki.migration.file");
        if (envMigrationFile != null) {
            propertiesFile = envMigrationFile;
        }
        cc.processMigration(propertiesFile);
    }

    protected void processMigration(String propertiesFile) {
        this.loadPropertiesFromFile(propertiesFile);
        this.initConnectors();
        this.initMacros();
        boolean processed = this.run();
        this.dumpStatistics();
        this.stop();
        if (!processed) {
            throw new ConfluenceCrawlerException("Page processing failed");
        }
    }

    public void loadPropertiesFromFile(String propertiesFile) {
        LOGGER.info("Using input file : " + propertiesFile);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFile));
        }
        catch (IOException e) {
            LOGGER.error("Can not load property file : " + propertiesFile);
            return;
        }
        this.sourceHost = properties.getProperty("sourceHost");
        this.sourceSpace = properties.getProperty("sourceSpace");
        String sourcePage = properties.getProperty("sourcePage");
        this.sourcePages = sourcePage.split("\\|");
        this.sourceUser = properties.getProperty("sourceUser");
        this.sourcePwd = properties.getProperty("sourcePwd");
        String sourcePwdFromEnv = System.getProperty("wiki.source.pwd");
        if (sourcePwdFromEnv != null && !"".equals(sourcePwdFromEnv)) {
            this.sourcePwd = sourcePwdFromEnv;
        }
        this.targetHost = properties.getProperty("targetHost");
        this.targetSpace = properties.getProperty("targetSpace");
        this.targetPage = properties.getProperty("targetPage");
        this.targetSyntax = properties.getProperty("targetSyntax");
        this.targetUser = properties.getProperty("targetUser");
        this.targetPwd = properties.getProperty("targetPwd");
        String targetPwdFromEnv = System.getProperty("wiki.target.pwd");
        if (targetPwdFromEnv != null && !"".equals(targetPwdFromEnv)) {
            this.targetPwd = targetPwdFromEnv;
        }
        LOGGER.info(String.format("%s:%s:%s", this.sourceHost, this.sourceUser, this.sourcePwd));
        LOGGER.info(String.format("%s:%s:%s", this.targetHost, this.targetUser, this.targetPwd));
        this.optionRecursiveCrawling = Boolean.valueOf(properties.getProperty("recurseOnChildren"));
        this.optionStopOnFailure = Boolean.valueOf(properties.getProperty("stopOnFailure"));
        this.optionTransferAttachments = Boolean.valueOf(properties.getProperty("transferAttachments"));
        this.optionTransferComments = Boolean.valueOf(properties.getProperty("transferComments"));
        this.optionTransferLabels = Boolean.valueOf(properties.getProperty("transferLabels"));
        int paramMaxAttachmentSize = Integer.valueOf(properties.getProperty("maxAttachmentSize", "0"));
        if (paramMaxAttachmentSize > 0) {
            this.optionMaxAttachmentSize = paramMaxAttachmentSize;
        }
        this.optionUploadAs = properties.getProperty("uploadType", "attachment");
        this.crawlerActions = properties.getProperty("migrationActions");
        Object[] actions = this.crawlerActions.split(",");
        Arrays.sort(actions);
        if (Arrays.binarySearch(actions, "check") >= 0) {
            this.actionCheckPageEnabled = true;
        }
        if (Arrays.binarySearch(actions, "perform") >= 0) {
            this.actionTransfertPageEnabled = true;
        }
        if (Arrays.binarySearch(actions, "sync") >= 0) {
            this.actionSyncAttachments = true;
        }
        LOGGER.info(String.format("Login %s  on %s", this.targetUser, this.targetHost));
        this.targetType = properties.getProperty("targetType");
        if (this.targetType == null) {
            this.targetType = "exowiki";
        }
    }

    private void initConnectors() {
        this.initializeConfluence();
        this.initializeHandler(this.targetHost, this.targetUser, this.targetPwd, this.targetType);
    }

    private void initializeHandler(String targetHost, String targetUser, String targetPwd, String targetType) {
        if ("wikbook".equals(targetType)) {
            LOGGER.info("Export to Wikbook format");
            this.wikiHandler = new WikbookWikiHandler(targetHost, this.targetSpace + "/" + this.targetPage);
        } else {
            LOGGER.info("Export to ExoWiki format on " + targetHost);
            this.wikiHandler = new ExoWikiHandler(targetHost);
        }
        this.wikiHandler.start(targetUser, targetPwd);
    }

    private void initializeConfluence() {
        try {
            this.confluence = new Confluence(this.sourceHost);
        }
        catch (MalformedURLException e) {
            throw new ConfluenceCrawlerException("Invalid Confluence URL : " + this.sourceHost, e);
        }
        try {
            LOGGER.info(String.format("Check login %s on %s", this.sourceUser, this.sourceHost));
            this.confluence.login(this.sourceUser, this.sourcePwd);
        }
        catch (SwizzleException e) {
            throw new ConfluenceCrawlerException("Cannot login into Confluence", e);
        }
    }

    public void initMacros() {
        MacroMap.addMacro(this.supportedMacrosMap, "*", "_", "+", "panel", "code", "color", "column", "info", "note", "pagetree", "toc", "section", "children", "table", "table-cell", "table-row");
        MacroMap.addMacro(this.unsupportedMacrosMap, "jiraissues", "contentbylabel", "include", "mockup", "gliffy", "excerpt", "recently-updated", "float", "noformat", "tip", "warning", "jira", "attachments", "excel", "viewppt", "viewpdf", "uml-sequence", "widget", "table-plus", "tasklist", "bookmarks");
    }

    public boolean run() {
        boolean processed = true;
        if (this.confluence == null) {
            throw new ConfluenceCrawlerException("Confluence not connected");
        }
        for (String pageToTransfer : this.sourcePages) {
            if ((pageToTransfer = pageToTransfer.replace('+', ' ')).length() == 0) continue;
            try {
                Page page = this.confluence.getPage(this.sourceSpace, pageToTransfer);
                StringBuilder targetPath = new StringBuilder(this.targetSpace).append("/").append(this.targetPage);
                if (this.wikiHandler.checkPageExists(targetPath.toString())) {
                    LOGGER.info("Crawling page : " + pageToTransfer);
                    this.crawlPage(page, this.targetPage);
                    continue;
                }
                LOGGER.error(String.format("[ERROR] Target page %s not found.", targetPath.toString()));
                processed = false;
            }
            catch (SwizzleException e) {
                LOGGER.error("[LOAD] Source page not found in source wiki :" + pageToTransfer);
                processed = false;
            }
        }
        return processed &= this.erroredElement.isEmpty();
    }

    private void stop() {
        this.wikiHandler.stop();
        this.logoutConfluence();
    }

    private void dumpStatistics() {
        LOGGER.info("Processing Done.");
        LOGGER.info("* Visited pages : " + this.visitedPages);
        LOGGER.info("* Created pages : " + this.transferredPages);
        LOGGER.info("* Uploaded attachements : " + this.transferredAttachments);
        LOGGER.info("* Macros usage :");
        this.dumpMacroUsage("** Supported : ", this.supportedMacrosMap);
        this.dumpMacroUsage("** Unsupported : ", this.unsupportedMacrosMap);
        this.dumpMacroUsage("** Unknow  : ", this.unknownMacrosMap);
        if (this.erroredElement.size() > 0) {
            LOGGER.error("* Errored pages or attachements : " + this.erroredElement.size());
            for (String path : this.erroredElement) {
                LOGGER.error("** " + path);
            }
        }
    }

    private void dumpMacroUsage(String title, Map<String, Integer> macroMap) {
        LOGGER.info("* " + title);
        StringBuilder macroText = new StringBuilder("*** ");
        ArrayList<String> sortedMacros = new ArrayList<String>();
        sortedMacros.addAll(macroMap.keySet());
        Collections.sort(sortedMacros);
        for (String macro : sortedMacros) {
            int usageCount = macroMap.get(macro);
            if (usageCount <= 0) continue;
            macroText.append(macro).append("(").append(usageCount).append("), ");
        }
        LOGGER.info(macroText.toString());
    }

    private boolean crawlPage(Page page, String subPath) {
        ++this.visitedPages;
        String pageName = page.getTitle();
        LOGGER.info(String.format("---- Processing -- " + this.visitedPages + " : %s/%s", subPath, pageName));
        try {
            boolean pageProcessed;
            String createdPageName = this.processPage(page, subPath, pageName);
            boolean bl = pageProcessed = createdPageName != null;
            if (createdPageName != null && this.optionRecursiveCrawling) {
                List children = this.confluence.getChildren(page.getId());
                String newPath = subPath + "/" + createdPageName;
                for (PageSummary childSummary : children) {
                    Page childPage = this.confluence.getPage(childSummary);
                    if (!this.optionStopOnFailure || (pageProcessed &= this.crawlPage(childPage, newPath))) continue;
                    return false;
                }
            }
            return pageProcessed;
        }
        catch (SwizzleException e) {
            LOGGER.error("[Crawl] Page processing failed :" + e.getMessage());
            return false;
        }
    }

    protected String processPage(Page page, String subPath, String pageName) throws SwizzleException {
        String createdPageName = null;
        String path = this.targetSpace;
        if (subPath.length() > 0) {
            path = this.targetSpace + "/" + subPath;
        }
        if (this.actionCheckPageEnabled) {
            this.performCheckPageContent(page);
        }
        if (this.actionTransfertPageEnabled) {
            String newPageName = this.wikiHandler.createPage(path, pageName, this.confluence.getChildren(page.getId()).size() > 0, this.targetSyntax);
            if (newPageName != null) {
                List labels;
                List comments;
                String pagePath = path + "/" + newPageName;
                createdPageName = newPageName;
                StringBuilder content = new StringBuilder();
                String mainContent = this.formatContent(page.getContent());
                content.append(mainContent);
                boolean xwiki2format = "xwiki2".equals(this.targetSyntax);
                if (this.optionTransferComments && (comments = this.confluence.getComments(page.getId())).size() > 0) {
                    content.append("\r\n\r\nComments:\r\n");
                    for (Comment comment : comments) {
                        String commentContent = comment.getContent();
                        String commentCreator = comment.getCreator();
                        content.append("\r\n");
                        content.append(xwiki2format ? "{{box}}" : "{pane}");
                        content.append("\r\n");
                        content.append(commentCreator);
                        content.append(" : ");
                        content.append(this.formatContent(commentContent));
                        content.append("\r\n");
                        content.append(xwiki2format ? "{{/box}}" : "{pane}");
                        content.append("\r\n");
                    }
                }
                if (this.optionTransferLabels && (labels = this.confluence.getLabelsById(Long.valueOf(page.getId()).longValue())).size() > 0) {
                    content.append("\r\n\r\n");
                    content.append("{{info}}");
                    content.append("Labels: ");
                    content.append("\r\n\r\n");
                    for (Label label : labels) {
                        content.append(label.getName()).append(", ");
                    }
                    content.append("\r\n");
                    content.append(xwiki2format ? "{{/info}}" : "{info}");
                    content.append("\r\n");
                }
                this.wikiHandler.transferContent(content.toString(), pagePath);
                if (this.optionTransferAttachments) {
                    this.uploadAttachments(this.confluence, page, this.targetSpace, subPath, createdPageName);
                }
                ++this.transferredPages;
            } else {
                String expectedPageName = this.wikiHandler.normalizePageName(pageName, true);
                if (this.wikiHandler.checkPageExists(path + "/" + expectedPageName)) {
                    createdPageName = expectedPageName;
                    LOGGER.warn("[Create] Content and attachements NOT replaced");
                } else {
                    LOGGER.error("[Create] Page NOT created");
                    this.erroredElement.add(subPath + "/" + pageName);
                }
            }
        }
        if (this.actionSyncAttachments) {
            String expectedPageName = this.wikiHandler.normalizePageName(pageName, true);
            if (this.wikiHandler.checkPageExists(path + "/" + expectedPageName)) {
                createdPageName = expectedPageName;
                this.uploadAttachments(this.confluence, page, this.targetSpace, subPath, createdPageName);
            }
        }
        return createdPageName;
    }

    private String formatContent(String content) {
        if ("xwiki2".equals(this.targetSyntax)) {
            return SyntaxTransformer.transformContent(content);
        }
        return content;
    }

    protected void performCheckPageContent(Page page) {
        HashMap<String, Integer> newMacros = new HashMap<String, Integer>();
        MacroExtractor.extractMacro(newMacros, page.getContent());
        Set<String> supportedMacros = this.supportedMacrosMap.keySet();
        Set<String> unsupportedMacros = this.unsupportedMacrosMap.keySet();
        for (String macro : newMacros.keySet()) {
            if (supportedMacros.contains(macro)) {
                MacroMap.addMacro(this.supportedMacrosMap, macro);
                continue;
            }
            if (unsupportedMacros.contains(macro)) {
                MacroMap.addMacro(this.unsupportedMacrosMap, macro);
                continue;
            }
            MacroMap.addMacro(this.unknownMacrosMap, macro);
        }
        ArrayList<String> sortedMacros = new ArrayList<String>();
        sortedMacros.addAll(newMacros.keySet());
        Collections.sort(sortedMacros);
        StringBuilder macroText = new StringBuilder("** Macros : ");
        for (String macro : sortedMacros) {
            macroText.append(macro).append(", ");
        }
        LOGGER.info(macroText.toString());
    }

    protected void uploadAttachments(Confluence confluence, Page page, String targetSpace, String parentPagePath, String pageName) throws SwizzleException {
        List attachments = confluence.getAttachments(page.getId());
        for (Attachment attachment : attachments) {
            String fileName = attachment.getFileName();
            Long fileSize = Long.parseLong(attachment.getFileSize()) / 1024L;
            if (fileSize > (long)this.optionMaxAttachmentSize) {
                LOGGER.error(String.format("[Upload] REJECTED Too big (%s ko) : %s/%s/%s", fileSize, targetSpace, pageName, fileName));
                this.erroredElement.add(parentPagePath + "/" + pageName);
                continue;
            }
            boolean attachmentExists = false;
            attachmentExists = "document".equals(this.optionUploadAs) ? this.wikiHandler.checkAttachmentExists(targetSpace, parentPagePath + "/" + pageName, fileName) : this.wikiHandler.checkAttachmentExists(targetSpace, parentPagePath + "/" + pageName, fileName);
            if (attachmentExists) {
                LOGGER.info(String.format("[Upload] Attachement %s already exists in %s/%s", fileName, targetSpace, pageName));
                continue;
            }
            this.performAttachmentUpload(page, targetSpace, parentPagePath, pageName, attachment);
        }
    }

    private void performAttachmentUpload(Page page, String targetSpace, String parentPagePath, String pageName, Attachment attachment) {
        String url = attachment.getUrl();
        String fileName = attachment.getFileName();
        Long fileSize = Long.parseLong(attachment.getFileSize()) / 1024L;
        String version = url.replaceAll(".*version=", "");
        version = version.replaceAll("&.*", "");
        LOGGER.info(String.format("[Upload] Processing %s ko - %s/%s/%s", fileSize, targetSpace, pageName, fileName));
        try {
            boolean uploaded = false;
            byte[] data = this.confluence.getAttachmentData(page.getId(), attachment.getFileName(), version);
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            uploaded = "document".equals(this.optionUploadAs) ? this.wikiHandler.uploadDocument(targetSpace, parentPagePath + "/" + pageName, fileName, attachment.getContentType(), stream) : this.wikiHandler.uploadAttachment(targetSpace, pageName, fileName, attachment.getContentType(), stream);
            if (uploaded) {
                ++this.transferredAttachments;
            } else {
                this.erroredElement.add(parentPagePath + "/" + pageName);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[Upload] Attachment failed to upload : %s in %s", fileName, pageName));
        }
    }

    private void logoutConfluence() {
        try {
            this.confluence.logout();
            this.confluence = null;
        }
        catch (SwizzleException e) {
            throw new ConfluenceCrawlerException("Cannot logout from Confluence", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UPLOAD_TYPE {
        ATTACHMENT,
        DOCUMENT;

    }
}

