/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.impl.ForumEventListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ForumSpaceActivityPublisher
extends ForumEventListener {
    private static Log LOG = ExoLogger.getExoLogger(ForumSpaceActivityPublisher.class);

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    public void savePost(Post post, String forumId) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String msg = "@" + post.getOwner() + " has added a new post <a href=" + post.getLink() + ">" + post.getName() + "</a>";
            String body = post.getLink();
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            SpaceService spaceS = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
            String spaceId = forumId.split(Utils.FORUM)[1];
            Space space = spaceS.getSpaceById(spaceId);
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", space.getId(), false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post " + e.getMessage()));
        }
    }

    public void saveTopic(Topic topic, String forumId) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String msg = "@" + topic.getOwner() + " has been posted: <a href=" + topic.getLink() + ">" + topic.getTopicName() + "</a>";
            String body = topic.getLink();
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            SpaceService spaceS = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
            String spaceId = forumId.split(Utils.FORUM)[1];
            Space space = spaceS.getSpaceById(spaceId);
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", space.getId(), false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when add topic " + e.getMessage()));
        }
    }
}

