/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Date;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ks/social-integration/plugin/space/AnswerUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={ToggleReplyActionListener.class}), @EventConfig(listeners={ReplyActionListener.class})})
public class AnswerUIActivity
extends BaseUIActivity {
    private static final String ANSWER = "Answer";
    private static final String COMMENT = "Comment";
    private static final String NONE = "None";
    protected Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private String replyBlock = "None";
    UIFormInputInfo questionTitle = null;
    UIFormInputInfo questionDetail = null;
    UIFormTextAreaInput contentArea = null;

    public void renderReplyBlock() {
        if (this.questionTitle == null) {
            this.questionTitle = new UIFormInputInfo("QuestionTitle" + this.getId(), "QuestionTitle", this.getActivityParamValue("Name"));
            this.questionDetail = new UIFormInputInfo("QuestionDetail" + this.getId(), "QuestionDetail", this.getActivity().getBody());
            this.contentArea = new UIFormTextAreaInput("Content" + this.getId(), "Content", "");
            this.addChild((UIComponent)this.questionTitle);
            this.addChild((UIComponent)this.questionDetail);
            this.addChild((UIComponent)this.contentArea);
        }
    }

    private String getTitle(WebuiBindingContext _ctx) throws Exception {
        String title = "";
        if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("QuestionAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.question-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("QuestionUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.question-update");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("AnswerAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.answer-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("AnswerUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.answer-update");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("CommentAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.comment-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("CommentUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.comment-update");
        }
        title = title.replace("{0}", this.getActivity().getTitle()).replace("{1}", "<a href=" + this.getActivityParamValue("Link") + ">" + this.getActivityParamValue("Name") + "</a>");
        return title;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    public boolean isQuestionActivity() {
        String value = this.getActivityParamValue("ActivityType");
        return value.indexOf("Question") >= 0;
    }

    public static String getFullName(String userName) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            User user = organizationService.getUserHandler().findUserByName(userName);
            String fullName = user.getFullName();
            if (fullName == null || fullName.trim().length() <= 0) {
                fullName = userName;
            }
            return fullName;
        }
        catch (Exception e) {
            return userName;
        }
    }

    public static String getLinkDiscuss(String topicId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String link = portalContext.getRequest().getRequestURL().toString();
        String selectedNode = Util.getUIPortal().getSelectedNode().getUri();
        String portalName = "/" + Util.getUIPortal().getName();
        if (link.indexOf(portalName) > 0 && link.indexOf(portalName + "/" + selectedNode) < 0) {
            link = link.replaceFirst(portalName, portalName + "/" + selectedNode);
        }
        link = link.substring(0, link.indexOf(selectedNode) + selectedNode.length());
        link = link.replaceAll(selectedNode, "forum") + "/" + Utils.TOPIC + "/" + topicId;
        return link;
    }

    private Answer[] updateDiscussForum(Question question, Answer[] answers) throws Exception {
        ForumService forumService;
        Topic topic;
        String topicId = question.getTopicIdDiscuss();
        if (topicId != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class)).getObjectNameById(topicId, Utils.TOPIC)) != null) {
            String[] ids = topic.getPath().split("/");
            int t = ids.length;
            String linkForum = AnswerUIActivity.getLinkDiscuss(topicId);
            int l = answers.length;
            String remoteAddr = org.exoplatform.ks.common.Utils.getRemoteIP();
            for (int i = 0; i < l; ++i) {
                Post post;
                String postId = answers[i].getPostId();
                if (postId != null && postId.length() > 0) {
                    post = forumService.getPost(ids[t - 3], ids[t - 2], topicId, postId);
                    if (post == null) {
                        post = new Post();
                        post.setOwner(answers[i].getResponseBy());
                        post.setName("Re: " + question.getQuestion());
                        post.setIcon("ViewIcon");
                        answers[i].setPostId(post.getId());
                        post.setMessage(answers[i].getResponses());
                        post.setLink(linkForum);
                        post.setIsApproved(!topic.getIsModeratePost());
                        post.setRemoteAddr(remoteAddr);
                        forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, "");
                        continue;
                    }
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setMessage(answers[i].getResponses());
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, false, "");
                    continue;
                }
                post = new Post();
                post.setOwner(answers[i].getResponseBy());
                post.setName("Re: " + question.getQuestion());
                post.setIcon("ViewIcon");
                post.setMessage(answers[i].getResponses());
                post.setLink(linkForum);
                post.setIsApproved(!topic.getIsModeratePost());
                post.setRemoteAddr(remoteAddr);
                forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, "");
                answers[i].setPostId(post.getId());
            }
        }
        return answers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReplyActionListener
    extends EventListener<AnswerUIActivity> {
        public void execute(Event<AnswerUIActivity> event) throws Exception {
            AnswerUIActivity uiform = (AnswerUIActivity)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            UIApplication application = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
            if (uiform.contentArea.getValue() == null || ((String)uiform.contentArea.getValue()).trim().length() == 0) {
                application.addMessage(new ApplicationMessage("AnswerUIActivity.msg.content-empty", null, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            String type = context.getRequestParameter("objectId");
            FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            if (type.equalsIgnoreCase(AnswerUIActivity.ANSWER)) {
                Question question = faqService.getQuestionById(uiform.getActivityParamValue("QuestionId"));
                Answer answer = new Answer();
                answer.setDateResponse(new Date());
                String currentUser = context.getRemoteUser();
                answer.setResponseBy(currentUser);
                answer.setFullName(AnswerUIActivity.getFullName(currentUser));
                answer.setNew(true);
                answer.setResponses((String)uiform.contentArea.getValue());
                answer.setLanguage(uiform.getActivityParamValue("Language"));
                answer.setApprovedAnswers(Boolean.valueOf(true));
                answer.setActivateAnswers(Boolean.valueOf(true));
                answer.setNew(true);
                Answer[] answers = uiform.updateDiscussForum(question, new Answer[]{answer});
                faqService.saveAnswer(question.getPath(), answers);
                application.addMessage(new ApplicationMessage("you have posted an answer successfully!", (Object[])new String[0]));
                uiform.replyBlock = AnswerUIActivity.NONE;
                context.addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
            } else if (type.equalsIgnoreCase(AnswerUIActivity.COMMENT)) {
                this.postComment(event);
            }
            context.addUIComponentToUpdateByAjax((UIComponent)uiform);
        }

        private void postComment(Event<AnswerUIActivity> event) throws Exception {
            ForumService forumService;
            Topic topic;
            AnswerUIActivity uiform = (AnswerUIActivity)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            Question question = faqService.getQuestionById(uiform.getActivityParamValue("QuestionId"));
            Comment comment = new Comment();
            comment.setNew(true);
            comment.setCommentBy(context.getRemoteUser());
            comment.setComments((String)uiform.contentArea.getValue());
            comment.setFullName(AnswerUIActivity.getFullName(context.getRemoteUser()));
            String topicId = question.getTopicIdDiscuss();
            if (topicId != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class)).getObjectNameById(topicId, Utils.TOPIC)) != null) {
                String remoteAddr = org.exoplatform.ks.common.Utils.getRemoteIP();
                String[] ids = topic.getPath().split("/");
                int t = ids.length;
                String linkForum = AnswerUIActivity.getLinkDiscuss(topicId);
                String postId = comment.getPostId();
                if (postId == null || postId.length() == 0) {
                    Post post = new Post();
                    post.setOwner(context.getRemoteUser());
                    post.setIcon("ViewIcon");
                    post.setName("Re: " + question.getQuestion());
                    post.setMessage(comment.getComments());
                    post.setLink(linkForum);
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setRemoteAddr(remoteAddr);
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, "");
                    comment.setPostId(post.getId());
                } else {
                    Post post = forumService.getPost(ids[t - 3], ids[t - 2], topicId, postId);
                    boolean isNew = false;
                    if (post == null) {
                        post = new Post();
                        isNew = true;
                        post.setOwner(context.getRemoteUser());
                        post.setIcon("ViewIcon");
                        post.setName("Re: " + question.getQuestion());
                        comment.setPostId(post.getId());
                        post.setLink(linkForum);
                        post.setRemoteAddr(remoteAddr);
                    } else {
                        post.setModifiedBy(context.getRemoteUser());
                    }
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setMessage(comment.getComments());
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, isNew, "");
                }
            }
            faqService.saveComment(question.getPath(), comment, uiform.getActivityParamValue("Language"));
            UIApplication application = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
            application.addMessage(new ApplicationMessage("you have posted a comment successfully!", (Object[])new String[0]));
            uiform.replyBlock = AnswerUIActivity.NONE;
            context.addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleReplyActionListener
    extends EventListener<AnswerUIActivity> {
        public void execute(Event<AnswerUIActivity> event) throws Exception {
            AnswerUIActivity uiform = (AnswerUIActivity)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String type = context.getRequestParameter("objectId");
            if (type.equalsIgnoreCase(AnswerUIActivity.ANSWER)) {
                uiform.renderReplyBlock();
                if (uiform.replyBlock.equalsIgnoreCase(AnswerUIActivity.NONE)) {
                    uiform.replyBlock = AnswerUIActivity.ANSWER;
                } else if (uiform.replyBlock.equalsIgnoreCase(AnswerUIActivity.ANSWER)) {
                    uiform.replyBlock = AnswerUIActivity.NONE;
                }
            } else if (type.equalsIgnoreCase(AnswerUIActivity.COMMENT)) {
                uiform.renderReplyBlock();
                if (uiform.replyBlock.equalsIgnoreCase(AnswerUIActivity.NONE)) {
                    uiform.replyBlock = AnswerUIActivity.COMMENT;
                } else if (uiform.replyBlock.equalsIgnoreCase(AnswerUIActivity.COMMENT)) {
                    uiform.replyBlock = AnswerUIActivity.NONE;
                }
            }
            context.addUIComponentToUpdateByAjax((UIComponent)uiform);
        }
    }
}

