/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Date;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ks/social-integration/plugin/space/ForumUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={ToggleReplyActionListener.class}), @EventConfig(listeners={ReplyActionListener.class})})
public class ForumUIActivity
extends BaseUIActivity {
    private boolean displayMoreInfo = false;

    public boolean isDisplayMoreInfo() {
        return this.displayMoreInfo;
    }

    public void setDisplayMoreInfo(boolean displayMoreInfo) {
        this.displayMoreInfo = displayMoreInfo;
    }

    public void doMore() throws Exception {
        ForumService service = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (this.getChildById("ReplyTitle" + this.getId()) == null) {
            UIFormStringInput replyTitle = new UIFormStringInput("ReplyTitle" + this.getId(), "ReplyTitle", "RE: " + this.getActivityParamValue("PostName"));
            replyTitle.setLabel("RE: " + this.getActivityParamValue("PostName"));
            UIFormTextAreaInput replyContent = new UIFormTextAreaInput("ReplyContent" + this.getId(), "ReplyContent", null);
            this.addChild((UIComponent)replyTitle);
            this.addChild((UIComponent)replyContent);
        }
    }

    protected String getPostTitle() {
        return (String)this.getUIStringInput("ReplyTitle" + this.getId()).getValue();
    }

    protected String getPostContent() {
        return (String)this.getUIFormTextAreaInput("ReplyContent" + this.getId()).getValue();
    }

    protected void renderReplyTitle() throws Exception {
        this.renderChild("ReplyTitle" + this.getId());
    }

    protected void renderReplyContent() throws Exception {
        this.renderChild("ReplyContent" + this.getId());
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    private String[] getCensoredKeyword() throws Exception {
        ForumAdministration forumAdministration = ((ForumService)this.getApplicationComponent(ForumService.class)).getForumAdministration();
        String stringKey = forumAdministration.getCensoredKeyword();
        if (stringKey != null && stringKey.length() > 0) {
            if ((stringKey = stringKey.toLowerCase().replaceAll(", ", ",").replaceAll(" ,", ",")).contains(",")) {
                stringKey.replaceAll(";", ",");
                return stringKey.trim().split(",");
            }
            return stringKey.trim().split(";");
        }
        return new String[0];
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    static String buildForumLink(String url, String selectedNode, String portalName, String type, String id) throws Exception {
        if (url.indexOf(portalName) > 0 && url.indexOf(portalName + "/" + selectedNode) < 0) {
            url = url.replaceFirst(portalName, portalName + "/" + selectedNode);
        }
        selectedNode = portalName + "/" + selectedNode;
        url = url.substring(0, url.lastIndexOf(selectedNode) + selectedNode.length());
        StringBuilder link = new StringBuilder().append(url);
        if (!ForumUIActivity.isEmpty(type) && !ForumUIActivity.isEmpty(id)) {
            if (link.lastIndexOf("/") == link.length() - 1) {
                link.append(type);
            } else {
                link.append("/").append(type);
            }
            if (!id.equals(Utils.FORUM_SERVICE)) {
                link.append("/").append(id);
            }
        }
        return link.toString();
    }

    public static String createdForumLink(String type, String id) throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String url = pContext.getRequest().getRequestURL().toString();
        String selectedNode = Util.getUIPortal().getSelectedNode().getUri();
        String portalName = pContext.getPortalOwner();
        return ForumUIActivity.buildForumLink(url, selectedNode, portalName, type, id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReplyActionListener
    extends EventListener<ForumUIActivity> {
        public void execute(Event<ForumUIActivity> event) throws Exception {
            ForumUIActivity uiform = (ForumUIActivity)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            ForumService service = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            UIApplication uiapp = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
            String title = uiform.getPostTitle();
            String content = uiform.getPostContent();
            if (title == null || title.trim().length() == 0 || content == null || content.trim().length() == 0) {
                uiapp.addMessage(new ApplicationMessage("ForumUIActivity.msg.reply-empty", null, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)uiapp.getUIPopupMessages());
                return;
            }
            String link = ForumUIActivity.createdForumLink("topic", uiform.getActivityParamValue("TopicId")).replaceFirst("private", "public");
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < content.length(); ++j) {
                char c = content.charAt(j);
                if (c == '\t') {
                    buffer.append("&nbsp; &nbsp; ");
                    continue;
                }
                if (c == '\n') {
                    buffer.append("<br/>");
                    continue;
                }
                if (c == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    buffer.append("&apos;");
                    continue;
                }
                if (c == '&' || c == '&') {
                    buffer.append("&#x26;");
                    continue;
                }
                buffer.append(c);
            }
            Post post = new Post();
            post.setName(title);
            post.setMessage(buffer.toString());
            post.setOwner(context.getRemoteUser());
            post.setCreatedDate(new Date());
            post.setRemoteAddr(org.exoplatform.ks.common.Utils.getRemoteIP());
            post.setLink(link);
            service.savePost(uiform.getActivityParamValue("CateId"), uiform.getActivityParamValue("ForumId"), uiform.getActivityParamValue("TopicId"), post, true, "");
            uiform.setDisplayMoreInfo(false);
            uiapp.addMessage(new ApplicationMessage("ForumUIActivity.msg.reply-success", (Object[])new String[]{uiform.getPostTitle()}));
            context.addUIComponentToUpdateByAjax((UIComponent)uiapp.getUIPopupMessages());
            context.addUIComponentToUpdateByAjax(uiform.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleReplyActionListener
    extends EventListener<ForumUIActivity> {
        public void execute(Event<ForumUIActivity> event) throws Exception {
            ForumUIActivity uiform = (ForumUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            uiform.setDisplayMoreInfo(!uiform.isDisplayMoreInfo());
            uiform.doMore();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiform);
        }
    }
}

