/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Map;
import org.exoplatform.ks.ext.impl.WikiUIActivity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class BaseKSActivity
extends BaseUIActivity {
    public static final Log log = ExoLogger.getLogger(WikiUIActivity.class);

    public String getUriOfAuthor() {
        try {
            return "<a href='" + this.getOwnerIdentity().getProfile().getUrl() + "'>" + this.getOwnerIdentity().getProfile().getFullName() + "</a>";
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Failed to get Url of user: %s", this.getOwnerIdentity().getProfile().getId()), (Throwable)e);
            }
            return "";
        }
    }

    public String getUserFullName(String userId) {
        return this.getOwnerIdentity().getProfile().getFullName();
    }

    public String getUserProfileUri(String userId) {
        return this.getOwnerIdentity().getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Failed to getSpaceById: %s", spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }
}

