/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.ext.impl.BaseKSActivity;
import org.exoplatform.ks.ext.impl.ForumSpaceActivityPublisher;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ks/social-integration/plugin/space/ForumUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class ForumUIActivity
extends BaseKSActivity {
    private String getReplyLink() {
        String link = this.getViewLink();
        if (!link.endsWith("/")) {
            link = link + "/";
        }
        link = link + "false";
        return link;
    }

    private String getViewLink() {
        String link = "";
        link = this.getActivityParamValue("ActivityType").toLowerCase().indexOf("topic") >= 0 ? this.getActivityParamValue("TopicLink") : this.getActivityParamValue("PostLink") + "/" + this.getActivityParamValue("PostId");
        return link;
    }

    private String getLink(String tagLink, String nameLink) {
        tagLink = StringUtils.replace((String)tagLink, (String)"{0}", (String)this.getViewLink());
        return StringUtils.replace((String)tagLink, (String)"{1}", (String)nameLink);
    }

    private String getActivityContentTitle(WebuiBindingContext _ctx, String herf) throws Exception {
        String title = "";
        String linkTag = "";
        try {
            if (this.getActivityParamValue("ActivityType").equalsIgnoreCase(ForumSpaceActivityPublisher.ACTIVITYTYPE.AddPost.toString())) {
                title = _ctx.appRes("ForumUIActivity.label.add-post");
                linkTag = this.getLink(herf, this.getActivityParamValue("PostName"));
            } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase(ForumSpaceActivityPublisher.ACTIVITYTYPE.UpdatePost.toString())) {
                title = _ctx.appRes("ForumUIActivity.label.update-post");
                linkTag = this.getLink(herf, this.getActivityParamValue("PostName"));
            } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase(ForumSpaceActivityPublisher.ACTIVITYTYPE.AddTopic.toString())) {
                title = _ctx.appRes("ForumUIActivity.label.add-topic");
                linkTag = this.getLink(herf, this.getActivityParamValue("TopicName"));
            } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase(ForumSpaceActivityPublisher.ACTIVITYTYPE.UpdateTopic.toString())) {
                title = _ctx.appRes("ForumUIActivity.label.update-topic");
                linkTag = this.getLink(herf, this.getActivityParamValue("TopicName"));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get activity content and title ", (Throwable)e);
        }
        if (!Utils.isEmpty((String)title)) {
            title = StringUtils.replace((String)title, (String)"{0}", (String)this.getUriOfAuthor());
            title = StringUtils.replace((String)title, (String)"{1}", (String)linkTag);
        }
        return title;
    }
}

